package cn.morethank.open.admin.common.domain;

import cn.morethank.open.admin.common.constant.GlobalConstant;
import lombok.Data;
import org.springframework.http.HttpStatus;

import java.io.Serializable;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@Data
public class Result<T> implements Serializable {

    /**
     * 状态码, 使用 HttpStatus 定义的值
     */
    private int status;

    /**
     * 错误码, 用于前端解析错误内容. 0表示成功无错误
     */
    private String errorCode = "0";

    /**
     * 消息提示
     */
    private String message;

    /**
     * 结果数据
     */
    private T data;

    private static <T> Result<T> result(int status, String errorCode, String message, T data) {
        Result<T> result = new Result<>();
        result.setStatus(status);
        result.setErrorCode(errorCode);
        result.setMessage(message);
        result.setData(data);
        return result;
    }

    public static <T> Result<T> success() {
        return success(GlobalConstant.SUCCESS, null);
    }

    public static <T> Result<T> success(T data) {
        return success(GlobalConstant.SUCCESS, data);
    }

    public static <T> Result<T> success(String message, T data) {
        return result(HttpStatus.OK.value(), null, message, data);
    }

    public static <T> Result<T> fail() {
        return fail(null, GlobalConstant.FAIL, null);
    }

    public static <T> Result<T> fail(String message) {
        return fail(null, message, null);
    }

    public static <T> Result<T> fail(String errorCode, String message) {
        return fail(errorCode, message, null);
    }

    public static <T> Result<T> fail(String errorCode, String message, T data) {
        return result(HttpStatus.BAD_REQUEST.value(), errorCode, message, data);
    }

    /**
     * 未授权
     */
    public static <T> Result<T> unauthorized() {
        return result(HttpStatus.UNAUTHORIZED.value(), ErrorCode.UNAUTHORIZED.code(), GlobalConstant.UNAUTHORIZED, null);
    }
}
