package cn.morethank.open.admin.common.controller;

import cn.morethank.open.admin.common.constant.GlobalConstant;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.domain.UserObject;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.common.service.SysLoginService;
import cn.morethank.open.admin.system.domain.SysMenu;
import cn.morethank.open.admin.system.service.SysMenuService;
import cn.morethank.open.admin.common.service.SysPermissionService;
import com.alibaba.fastjson2.JSONObject;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

/**
 * 登录相关接口
 * @author morethank
 * @since 2022/12/17 17:23
 */
@RestController
@AllArgsConstructor
public class SysLoginController {

    private final SysLoginService sysLoginService;
    private final SysPermissionService sysPermissionService;
    private final JwtService jwtService;
    private final SysMenuService sysMenuService;

    /**
     * 登录方法
     *
     * @param loginBody json格式的登录信息
     * @return 返回token
     */
    @PostMapping("/login")
    public Result login(@RequestBody JSONObject loginBody) {
        String username = loginBody.getString("username");
        String password = loginBody.getString("password");
        String code = loginBody.getString("code");
        String uuid = loginBody.getString("uuid");
        // 生成令牌
        String token = sysLoginService.login(username, password, code, uuid);
        return Result.success(GlobalConstant.SUCCESS, token);
    }

    /**
     * 获取用户信息
     *
     * @return 用户信息
     */
    @GetMapping("getInfo")
    public Result getInfo() {
        UserObject user = jwtService.getLoginAccount().getUser();
        // 角色集合
        Set<String> roles = sysPermissionService.getRolePermission(user);
        // 权限集合
        Set<String> permissions = sysPermissionService.getMenuPermission(user);
        JSONObject data = new JSONObject();
        data.put("user", user);
        data.put("roles", roles);
        data.put("permissions", permissions);
        return Result.success(data);
    }

    /**
     * 获取路由信息
     *
     * @return 路由信息
     */
    @GetMapping("getRouters")
    public Result getRouters() {
        UserObject user = jwtService.getLoginAccount().getUser();
        List<SysMenu> menus = sysMenuService.selectMenuTreeByUserId(user.getUserId());
        return Result.success(sysMenuService.buildMenus(menus));
    }

}
