package cn.morethank.open.admin.common.constant;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
public interface GlobalConstant {

    String[] IMAGE_EXTENSION = { "bmp", "gif", "jpg", "jpeg", "png" };

    String ADMIN_FORBIDDEN = "admin_forbidden";
    String EMPTY = "";
    int ZERO = 0;
    long CACHE_TIMEOUT = 300;

    String UNDELETED = "0";
    String DISABLED = "1";
    String DELETED = "2";

    String BEARER = "Bearer ";
    String AUTHORIZATION = "Authorization";
    String USER_AGENT = "User-Agent";

    String ADMIN = "admin";

    String COMMA = ",";
    String UNKNOWN = "unknown";

    String ALL_PERM = "*:*:*";

    String RSA_ALGORITHM = "RSA";
    String PUBLIC_KEY = "publicKey";
    String PRIVATE_KEY = "privateKey";

    String UTF8 = "UTF-8";
    String JSON_CONTENT_TYPE = "application/json;charset=UTF-8";
    String POST = "POST";
    String PUT = "PUT";
    String LOGIN_URL = "/login";

    String CODE = "code";
    String UUID = "uuid";
    String TOKEN = "token";
    String JPG = "jpg";
    String BASE64_IMG = "base64Img";

    String SUCCESS = "操作成功";
    String FAIL = "操作失败";
    String SUCCESS_STATUS = "0";
    String FAIL_STATUS = "1";
    String UNAUTHORIZED = "未授权访问";

    String CODE_ERROR = "验证码错误";
    String LOGIN_ERROR = "用户名或密码错误";
    String LOGIN_SUCCESS = "登录成功";


    /**
     * www主域
     */
    String WWW = "www.";

    /**
     * http请求
     */
    String HTTP = "http://";

    /**
     * https请求
     */
    String HTTPS = "https://";

    /**
     * 注销
     */
    String LOGOUT = "Logout";

    /**
     * 注册
     */
    String REGISTER = "Register";

    /**
     * 登录失败
     */
    String LOGIN_FAIL = "Error";

    /**
     * 资源映射路径 前缀
     */
    String RESOURCE_PREFIX = "/profile";

    /** 是否为系统默认（是） */
    String YES = "Y";

    /** 是否菜单外链（是） */
    String YES_FRAME = "0";

    /** 是否菜单外链（否） */
    String NO_FRAME = "1";

    /** 菜单类型（目录） */
    String TYPE_DIR = "M";

    /** 菜单类型（菜单） */
    String TYPE_MENU = "C";

    /** 菜单类型（按钮） */
    String TYPE_BUTTON = "F";

    /** Layout组件标识 */
    String LAYOUT = "Layout";

    /** ParentView组件标识 */
    String PARENT_VIEW = "ParentView";

    /** InnerLink组件标识 */
    String INNER_LINK = "InnerLink";

    /**
     * 时间氛围搜索条件相关的参数
     */
    String BEGIN_TIME = "beginTime";
    String END_TIME = "endTime";
    String DATE_FORMAT_GE = "DATE_FORMAT(create_time,'%Y-%m-%d') >= '";
    String DATE_FORMAT_LE = "DATE_FORMAT(create_time,'%Y-%m-%d') <= '";

    String LOGIN_FORMAT_GE = "DATE_FORMAT(login_time,'%Y-%m-%d') >= '";
    String LOGIN_FORMAT_LE = "DATE_FORMAT(login_time,'%Y-%m-%d') <= '";
    String SINGLE_QUOTATION = "'";
}
