package cn.morethank.open.admin.common.config;

import cn.morethank.open.admin.common.constant.GlobalConstant;
import cn.morethank.open.admin.common.inject.AntiInjectInterceptor;
import cn.morethank.open.admin.common.inject.AntiInjectRequestFilter;
import lombok.AllArgsConstructor;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@AllArgsConstructor
@Configuration
public class InterceptorConfig implements WebMvcConfigurer {

    private final AntiInjectInterceptor antiInjectInterceptor;

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        // 本地文件上传路径
        registry.addResourceHandler(GlobalConstant.RESOURCE_PREFIX + "/**")
                .addResourceLocations("file:" + AdminConfig.getProfile() + "/");
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        // sql, xss防注入防攻击拦截器
        registry.addInterceptor(antiInjectInterceptor).addPathPatterns("/**");
    }

    @Bean
    public FilterRegistrationBean<AntiInjectRequestFilter> Filters() {
        FilterRegistrationBean<AntiInjectRequestFilter> registrationBean = new FilterRegistrationBean<>();
        registrationBean.setFilter(new AntiInjectRequestFilter());
        registrationBean.addUrlPatterns("/*");
        registrationBean.setName("antiInjectRequestFilter");
        // 优先级设置为最高级
        registrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE);
        return registrationBean;
    }
}
