package cn.morethank.open.admin.common.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * 图形验证码的配置
 * @author morethank
 * @since 2022/12/17 17:23
 */
@Data
@EnableConfigurationProperties
@Configuration
@ConfigurationProperties(prefix = "open.admin.captcha")
public class CaptchaConfig {
    /**
     * 图片宽度
     */
    private int width;
    /**
     * 高度
     */
    private int height;
    /**
     * 验证码字符长度
     */
    private int len;
}
