package cn.morethank.open.admin.common.annotation;

import cn.morethank.open.admin.common.domain.BusinessType;
import cn.morethank.open.admin.common.domain.OperatorType;

import java.lang.annotation.*;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@Target({ ElementType.PARAMETER, ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface OperateLog {

    /**
     * 模块
     */
    public String title() default "";

    /**
     * 功能
     */
    public BusinessType businessType() default BusinessType.OTHER;

    /**
     * 操作人类别
     */
    public OperatorType operatorType() default OperatorType.MANAGE;

    /**
     * 是否保存请求的参数
     */
    public boolean isSaveRequestData() default true;

    /**
     * 是否保存响应的参数
     */
    public boolean isSaveResponseData() default true;
}
