package cn.morethank.open.admin.common.annotation;

import cn.morethank.open.admin.common.service.DictService;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * @author morethank
 * @since 2022/12/17 18:58
 */
public class ExcelStringDictConverter implements Converter<String> {

    @Override
    public Class<?> supportJavaTypeKey() {
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public WriteCellData<?> convertToExcelData(String value, ExcelContentProperty contentProperty
            , GlobalConfiguration globalConfiguration) throws Exception {
        ExcelFormat excelFormat = contentProperty.getField().getAnnotation(ExcelFormat.class);
        if(excelFormat != null && StringUtils.isNotEmpty(value)) {
            String separator = excelFormat.separator();
            if(StringUtils.isNotEmpty(excelFormat.expression())) {
                String expression = excelFormat.expression();
                String val = convertByExp(value, expression, separator);
                return new WriteCellData<>(val);
            } else if (StringUtils.isNotEmpty(excelFormat.dict())) {
                String dict = excelFormat.dict();
                String val = convertDictByExp(value, dict, separator);
                return new WriteCellData<>(val);
            }
        }
        return new WriteCellData<>(value);
    }

    private String convertByExp(String propertyValue, String converterExp, String separator) {
        StringBuilder propertyString = new StringBuilder();
        String[] convertSource = converterExp.split(",");
        for (String item : convertSource) {
            String[] itemArray = item.split("=");
            if (StringUtils.containsAny(propertyValue, separator)) {
                for (String value : propertyValue.split(separator)) {
                    if (itemArray[0].equals(value)) {
                        propertyString.append(itemArray[1] + separator);
                        break;
                    }
                }
            } else {
                if (itemArray[0].equals(propertyValue)) {
                    return itemArray[1];
                }
            }
        }
        return StringUtils.stripEnd(propertyString.toString(), separator);
    }

    private String convertDictByExp(String dictValue, String dictType, String separator) {
        // 获取bean
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        WebApplicationContext wc = RequestContextUtils.findWebApplicationContext(request);
        DictService dictService = wc.getBean(DictService.class);
        return dictService.getDictLabel(dictType, dictValue, separator);
    }
}
