package cn.morethank.open.admin.common.annotation;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.util.NumberUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * @author morethank
 * @since 2022/12/17 23:34
 */
public class ExcelIntegerDictConverter implements Converter<Integer> {

    @Override
    public Class<?> supportJavaTypeKey() {
        return Integer.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public WriteCellData<?> convertToExcelData(Integer value, ExcelContentProperty contentProperty
            , GlobalConfiguration globalConfiguration) throws Exception {
        ExcelFormat excelFormat = contentProperty.getField().getAnnotation(ExcelFormat.class);
        if(excelFormat != null && value != null) {
            String separator = excelFormat.separator();
            if(StringUtils.isNotEmpty(excelFormat.expression())) {
                String expression = excelFormat.expression();
                String val = convertByExp(value, expression, separator);
                return new WriteCellData<>(val);
            }
        }
        return NumberUtils.formatToCellDataString(value, contentProperty);
    }

    private String convertByExp(Integer propertyValue, String converterExp, String separator) {
        String val = String.valueOf(propertyValue);
        String[] convertSource = converterExp.split(",");
        for (String item : convertSource) {
            String[] itemArray = item.split("=");
            if (itemArray[0].equals(val)) {
                return itemArray[1];
            }
        }
        return StringUtils.stripEnd(val, separator);
    }
}
