package cn.morethank.open.admin.common.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author morethank
 * @since 2022/12/17 17:23
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface ExcelFormat {
    /**
     * 如果是字典类型，请设置字典的type值 (如: sys_user_sex)
     */
    String dict() default "";

    /**
     * 读取内容转表达式 (如: 0=男,1=女,2=未知)
     */
    String expression() default "";

    /**
     * 分隔符，读取字符串组内容
     */
    String separator() default ",";
}
