/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.common.exception.ServiceException;
import cn.morethank.open.admin.common.service.RedisService;
import cn.morethank.open.admin.common.service.RsaService;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysPost;
import cn.morethank.open.admin.system.domain.SysRole;
import cn.morethank.open.admin.system.domain.SysUser;
import cn.morethank.open.admin.system.domain.SysUserPost;
import cn.morethank.open.admin.system.domain.SysUserRole;
import cn.morethank.open.admin.system.mapper.SysPostMapper;
import cn.morethank.open.admin.system.mapper.SysRoleMapper;
import cn.morethank.open.admin.system.mapper.SysUserMapper;
import cn.morethank.open.admin.system.mapper.SysUserPostMapper;
import cn.morethank.open.admin.system.mapper.SysUserRoleMapper;
import cn.morethank.open.admin.system.service.SysMenuService;
import cn.morethank.open.admin.system.service.SysRoleService;
import cn.morethank.open.admin.system.service.SysUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SysUserServiceImpl
extends ServiceImpl<SysUserMapper, SysUser>
implements SysUserService {
    private final SysUserMapper sysUserMapper;
    private final SysRoleMapper sysRoleMapper;
    private final SysPostMapper sysPostMapper;
    private final RedisService redisService;
    private final SysRoleService sysRoleService;
    private final SysMenuService sysMenuService;
    private final SysUserPostMapper sysUserPostMapper;
    private final SysUserRoleMapper sysUserRoleMapper;
    private final RsaService rsaService;

    @Override
    public SysUser getByUsername(String username) {
        return this.sysUserMapper.selectUserByUserName(username);
    }

    @Override
    public IPage<SysUser> selectListPage(Page<SysUser> page, SysUser sysUser) {
        return this.sysUserMapper.selectListPage(page, sysUser);
    }

    @Override
    public String getUserAuthorityInfo(Long userId) {
        SysUser sysUser = (SysUser)this.sysUserMapper.selectById(userId);
        String authority = "";
        if (this.redisService.hasKey("GrantedAuthority:" + sysUser.getUserName())) {
            authority = (String)this.redisService.get("GrantedAuthority:" + sysUser.getUserName());
        } else {
            List<Long> menuIds;
            List roles = this.sysRoleService.list((Wrapper)new QueryWrapper().inSql((Object)"role_id", "select role_id from sys_user_role where user_id = " + userId));
            if (roles.size() > 0) {
                String roleCodes = roles.stream().map(r -> "ROLE_" + r.getRoleKey()).collect(Collectors.joining(","));
                authority = roleCodes.concat(",");
            }
            if ((menuIds = this.sysUserMapper.getNavMenuIds(userId)).size() > 0) {
                List menus = this.sysMenuService.listByIds(menuIds);
                String menuPerms = menus.stream().map(m -> m.getPerms()).collect(Collectors.joining(","));
                authority = authority.concat(menuPerms);
            }
            this.redisService.set("GrantedAuthority:" + sysUser.getUserName(), authority, 3600L);
        }
        return authority;
    }

    @Override
    public SysUser selectUserById(Long userId) {
        return this.sysUserMapper.selectUserById(userId);
    }

    @Override
    public void checkUserAllowed(SysUser sysUser) {
        if (StringUtils.isNotNull(sysUser.getUserId()) && sysUser.isAdmin()) {
            throw new ServiceException("\u4e0d\u5141\u8bb8\u64cd\u4f5c\u8d85\u7ea7\u7ba1\u7406\u5458\u7528\u6237");
        }
    }

    @Override
    public int deleteUserByIds(Long[] userIds) {
        for (Long userId : userIds) {
            this.checkUserAllowed(new SysUser(userId));
        }
        this.sysUserRoleMapper.deleteUserRole(userIds);
        this.sysUserPostMapper.deleteUserPost(userIds);
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        ArrayList arrayList = new ArrayList(userIds.length);
        Collections.addAll(arrayList, userIds);
        ((LambdaUpdateWrapper)lambdaUpdateWrapper.in(SysUser::getUserId, arrayList)).set(SysUser::getDelFlag, (Object)"2");
        return this.sysUserMapper.update(null, (Wrapper)lambdaUpdateWrapper);
    }

    @Override
    public boolean checkUserNameUnique(String userName) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUser::getUserName, (Object)userName);
        long count = this.sysUserMapper.selectCount((Wrapper)wrapper);
        return count > 0L;
    }

    @Override
    public boolean checkPhoneUnique(SysUser sysUser) {
        long count;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUser::getPhonenumber, (Object)sysUser.getPhonenumber());
        if (sysUser.getUserId() != null && sysUser.getUserId() > 0L) {
            wrapper.ne(SysUser::getUserId, (Object)sysUser.getUserId());
        }
        return (count = this.sysUserMapper.selectCount((Wrapper)wrapper).longValue()) > 0L;
    }

    @Override
    public boolean checkEmailUnique(SysUser sysUser) {
        long count;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUser::getEmail, (Object)sysUser.getEmail());
        if (sysUser.getUserId() != null && sysUser.getUserId() > 0L) {
            wrapper.ne(SysUser::getUserId, (Object)sysUser.getUserId());
        }
        return (count = this.sysUserMapper.selectCount((Wrapper)wrapper).longValue()) > 0L;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int insertUser(SysUser sysUser) {
        int rows = this.sysUserMapper.insert(sysUser);
        this.insertUserPost(sysUser);
        this.insertUserRole(sysUser);
        return rows;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updateUser(SysUser sysUser) {
        Long userId = sysUser.getUserId();
        this.sysUserRoleMapper.deleteUserRoleByUserId(userId);
        this.insertUserRole(sysUser);
        this.sysUserPostMapper.deleteUserPostByUserId(userId);
        this.insertUserPost(sysUser);
        return this.sysUserMapper.updateById(sysUser);
    }

    @Override
    public int resetPwd(SysUser sysUser) {
        String privateKey = (String)this.redisService.hget("privateKey", sysUser.getUuid());
        String rawPasswd = this.rsaService.privateDecrypt(sysUser.getPassword(), privateKey);
        this.log.warn(rawPasswd);
        String passwd = new BCryptPasswordEncoder().encode((CharSequence)rawPasswd);
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)lambdaUpdateWrapper.eq(SysUser::getUserId, (Object)sysUser.getUserId())).set(SysUser::getPassword, (Object)passwd);
        return this.sysUserMapper.update(null, (Wrapper)lambdaUpdateWrapper);
    }

    @Override
    public String selectUserRoleGroup(String userName) {
        List<SysRole> list = this.sysRoleMapper.selectRolesByUserName(userName);
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        return list.stream().map(SysRole::getRoleName).collect(Collectors.joining(","));
    }

    @Override
    public String selectUserPostGroup(String userName) {
        List<SysPost> list = this.sysPostMapper.selectPostsByUserName(userName);
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        return list.stream().map(SysPost::getPostName).collect(Collectors.joining(","));
    }

    @Override
    public void insertUserAuth(Long userId, Long[] roleIds) {
        this.sysUserRoleMapper.deleteUserRoleByUserId(userId);
        this.insertUserRole(userId, roleIds);
    }

    @Override
    public IPage<SysUser> selectAllocatedList(Page<SysUser> page, SysUser sysUser) {
        return this.sysUserMapper.selectAllocatedList(page, sysUser);
    }

    @Override
    public IPage<SysUser> selectUnallocatedList(Page<SysUser> page, SysUser sysUser) {
        return this.sysUserMapper.selectUnallocatedList(page, sysUser);
    }

    @Override
    public List<SysUser> selectUserList(SysUser sysUser) {
        return this.sysUserMapper.selectUserList(sysUser);
    }

    @Override
    public void checkUserDataScope(Long userId) {
        if (!SysUser.isAdmin(userId)) {
            SysUser user = new SysUser();
            user.setUserId(userId);
            List<SysUser> users = this.selectUserList(user);
            if (StringUtils.isEmpty(users)) {
                throw new ServiceException("\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u7528\u6237\u6570\u636e\uff01");
            }
        }
    }

    @Override
    public boolean updateUserAvatar(String userName, String avatar) {
        return this.sysUserMapper.updateUserAvatar(userName, avatar) > 0;
    }

    public void insertUserRole(SysUser sysUser) {
        this.insertUserRole(sysUser.getUserId(), sysUser.getRoleIds());
    }

    public void insertUserRole(Long userId, Long[] roleIds) {
        if (StringUtils.isNotEmpty(roleIds)) {
            ArrayList<SysUserRole> list = new ArrayList<SysUserRole>(roleIds.length);
            for (Long roleId : roleIds) {
                SysUserRole ur = new SysUserRole();
                ur.setUserId(userId);
                if (roleId == null) continue;
                ur.setRoleId(roleId);
                list.add(ur);
            }
            this.sysUserRoleMapper.batchUserRole(list);
        }
    }

    private void insertUserPost(SysUser sysUser) {
        Object[] posts = sysUser.getPostIds();
        if (StringUtils.isNotEmpty(posts)) {
            ArrayList<SysUserPost> list = new ArrayList<SysUserPost>(posts.length);
            for (Object postId : posts) {
                SysUserPost up = new SysUserPost();
                up.setUserId(sysUser.getUserId());
                up.setPostId((Long)postId);
                list.add(up);
            }
            this.sysUserPostMapper.batchUserPost(list);
        }
    }

    public SysUserServiceImpl(SysUserMapper sysUserMapper, SysRoleMapper sysRoleMapper, SysPostMapper sysPostMapper, RedisService redisService, SysRoleService sysRoleService, SysMenuService sysMenuService, SysUserPostMapper sysUserPostMapper, SysUserRoleMapper sysUserRoleMapper, RsaService rsaService) {
        this.sysUserMapper = sysUserMapper;
        this.sysRoleMapper = sysRoleMapper;
        this.sysPostMapper = sysPostMapper;
        this.redisService = redisService;
        this.sysRoleService = sysRoleService;
        this.sysMenuService = sysMenuService;
        this.sysUserPostMapper = sysUserPostMapper;
        this.sysUserRoleMapper = sysUserRoleMapper;
        this.rsaService = rsaService;
    }
}

