/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.service.impl;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.domain.BaseEntity;
import cn.morethank.open.admin.common.exception.ServiceException;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.common.util.QueryWrapperUtil;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysRole;
import cn.morethank.open.admin.system.domain.SysRoleMenu;
import cn.morethank.open.admin.system.domain.SysUserRole;
import cn.morethank.open.admin.system.mapper.SysRoleMapper;
import cn.morethank.open.admin.system.mapper.SysRoleMenuMapper;
import cn.morethank.open.admin.system.mapper.SysUserRoleMapper;
import cn.morethank.open.admin.system.service.SysRoleService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysRoleServiceImpl
extends ServiceImpl<SysRoleMapper, SysRole>
implements SysRoleService {
    private final SysRoleMapper sysRoleMapper;
    private final SysRoleMenuMapper sysRoleMenuMapper;
    private final SysUserRoleMapper sysUserRoleMapper;
    private final JwtService jwtService;

    @Override
    public IPage<SysRole> selectListPage(Page<SysRole> page, LambdaQueryWrapper<SysRole> query) {
        return this.sysRoleMapper.selectPage((IPage)page, (Wrapper)query);
    }

    @Override
    public Collection<String> selectRolePermissionByUserId(Long userId) {
        List<SysRole> perms = this.sysRoleMapper.selectRolePermissionByUserId(userId);
        HashSet<String> permsSet = new HashSet<String>();
        for (SysRole perm : perms) {
            if (perm == null) continue;
            permsSet.addAll(Arrays.asList(perm.getRoleKey().trim().split(",")));
        }
        return permsSet;
    }

    @Override
    public int updateRoleStatus(SysRole role) {
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)lambdaUpdateWrapper.eq(SysRole::getRoleId, (Object)role.getRoleId())).set(SysRole::getStatus, (Object)role.getStatus())).set(BaseEntity::getUpdateBy, (Object)this.jwtService.getUserName())).set(BaseEntity::getUpdateTime, (Object)LocalDateTime.now());
        return this.sysRoleMapper.update(null, (Wrapper)lambdaUpdateWrapper);
    }

    @Override
    public void checkRoleAllowed(SysRole role) {
        if (StringUtils.isNotNull(role.getRoleId()) && role.isAdmin()) {
            throw new ServiceException("\u4e0d\u5141\u8bb8\u5bf9\u8d85\u7ea7\u7ba1\u7406\u5458\u89d2\u8272\u505a\u64cd\u4f5c");
        }
    }

    @Override
    public boolean checkRoleNameUnique(SysRole role) {
        long count;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysRole::getDelFlag, (Object)"0")).eq(SysRole::getRoleName, (Object)role.getRoleName());
        if (role.getRoleId() != null && role.getRoleId() > 0L) {
            wrapper.ne(SysRole::getRoleId, (Object)role.getRoleId());
        }
        return (count = this.sysRoleMapper.selectCount((Wrapper)wrapper).longValue()) > 0L;
    }

    @Override
    public boolean checkRoleKeyUnique(SysRole role) {
        long count;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysRole::getDelFlag, (Object)"0")).eq(SysRole::getRoleKey, (Object)role.getRoleKey());
        if (role.getRoleId() != null && role.getRoleId() > 0L) {
            wrapper.ne(SysRole::getRoleId, (Object)role.getRoleId());
        }
        return (count = this.sysRoleMapper.selectCount((Wrapper)wrapper).longValue()) > 0L;
    }

    @Override
    public int insertRole(SysRole role) {
        this.sysRoleMapper.insert(role);
        return this.insertRoleMenu(role);
    }

    @Override
    public int deleteRoleByIds(Long[] roleIds) {
        for (Long roleId : roleIds) {
            this.checkRoleAllowed(new SysRole(roleId));
            SysRole role = (SysRole)this.getById(roleId);
            if (this.countUserRoleByRoleId(roleId) <= 0) continue;
            throw new ServiceException(String.format("%1$s\u5df2\u5206\u914d,\u4e0d\u80fd\u5220\u9664", role.getRoleName()));
        }
        this.sysRoleMenuMapper.deleteRoleMenu(roleIds);
        ArrayList arrayList = new ArrayList(roleIds.length);
        Collections.addAll(arrayList, roleIds);
        return this.sysRoleMapper.deleteBatchIds(arrayList);
    }

    @Override
    public int countUserRoleByRoleId(Long roleId) {
        return this.sysRoleMenuMapper.countUserRoleByRoleId(roleId);
    }

    @Override
    public int updateRole(SysRole role) {
        this.sysRoleMapper.updateRole(role);
        this.sysRoleMenuMapper.deleteRoleMenuByRoleId(role.getRoleId());
        return this.insertRoleMenu(role);
    }

    @Override
    public List<SysRole> selectRolesByUserId(Long userId) {
        List<SysRole> userRoles = this.sysRoleMapper.selectRolePermissionByUserId(userId);
        List<SysRole> roles = this.selectRoleList(new SysRole());
        block0: for (SysRole role : roles) {
            for (SysRole userRole : userRoles) {
                if (role.getRoleId().longValue() != userRole.getRoleId().longValue()) continue;
                role.setFlag(true);
                continue block0;
            }
        }
        return roles;
    }

    @Override
    public List<SysRole> selectRoleList(SysRole sysRole) {
        LambdaQueryWrapper<SysRole> query = this.getQueryWrapper(sysRole);
        return this.sysRoleMapper.selectList((Wrapper)query);
    }

    @Override
    public int insertAuthUsers(Long roleId, Long[] userIds) {
        ArrayList<SysUserRole> list = new ArrayList<SysUserRole>();
        for (Long userId : userIds) {
            SysUserRole ur = new SysUserRole();
            ur.setUserId(userId);
            ur.setRoleId(roleId);
            list.add(ur);
        }
        return this.sysUserRoleMapper.batchUserRole(list);
    }

    @Override
    public int deleteAuthUser(SysUserRole userRole) {
        return this.sysUserRoleMapper.deleteUserRoleInfo(userRole);
    }

    @Override
    public int deleteAuthUsers(Long roleId, Long[] userIds) {
        return this.sysUserRoleMapper.deleteUserRoleInfos(roleId, userIds);
    }

    public int insertRoleMenu(SysRole role) {
        int rows = 1;
        ArrayList<SysRoleMenu> list = new ArrayList<SysRoleMenu>();
        for (Long menuId : role.getMenuIds()) {
            SysRoleMenu rm = new SysRoleMenu();
            rm.setRoleId(role.getRoleId());
            rm.setMenuId(menuId);
            list.add(rm);
        }
        if (list.size() > 0) {
            rows = this.sysRoleMenuMapper.batchRoleMenu(list);
        }
        return rows;
    }

    private LambdaQueryWrapper<SysRole> getQueryWrapper(SysRole sysRole) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)sysRole.getRoleName())) {
            query.like(SysRole::getRoleName, (Object)sysRole.getRoleName());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysRole.getRoleKey())) {
            query.like(SysRole::getRoleKey, (Object)sysRole.getRoleKey());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysRole.getStatus())) {
            query.eq(SysRole::getStatus, (Object)sysRole.getStatus());
        }
        QueryWrapperUtil.createTimeCondition(query, sysRole.getParams());
        query.orderByAsc(SysRole::getRoleSort);
        return query;
    }

    public SysRoleServiceImpl(SysRoleMapper sysRoleMapper, SysRoleMenuMapper sysRoleMenuMapper, SysUserRoleMapper sysUserRoleMapper, JwtService jwtService) {
        this.sysRoleMapper = sysRoleMapper;
        this.sysRoleMenuMapper = sysRoleMenuMapper;
        this.sysUserRoleMapper = sysUserRoleMapper;
        this.jwtService = jwtService;
    }
}

