/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.common.exception.ServiceException;
import cn.morethank.open.admin.system.domain.SysPost;
import cn.morethank.open.admin.system.mapper.SysPostMapper;
import cn.morethank.open.admin.system.mapper.SysUserPostMapper;
import cn.morethank.open.admin.system.service.SysPostService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysPostServiceImpl
extends ServiceImpl<SysPostMapper, SysPost>
implements SysPostService {
    private final SysPostMapper sysPostMapper;
    private final SysUserPostMapper sysUserPostMapper;

    @Override
    public IPage<SysPost> selectListPage(Page<SysPost> page, LambdaQueryWrapper<SysPost> query) {
        return this.sysPostMapper.selectPage((IPage)page, (Wrapper)query);
    }

    @Override
    public int deletePostByIds(Long[] postIds) {
        for (Long postId : postIds) {
            SysPost post = (SysPost)this.getById(postId);
            if (this.countUserPostById(postId) <= 0) continue;
            throw new ServiceException(String.format("%1$s\u5df2\u5206\u914d,\u4e0d\u80fd\u5220\u9664", post.getPostName()));
        }
        return this.sysPostMapper.deletePostByIds(postIds);
    }

    @Override
    public int countUserPostById(Long postId) {
        return this.sysUserPostMapper.countUserPostById(postId);
    }

    @Override
    public boolean checkPostNameUnique(SysPost post) {
        long count;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysPost::getPostName, (Object)post.getPostName());
        if (post.getPostId() != null && post.getPostId() > 0L) {
            wrapper.ne(SysPost::getPostId, (Object)post.getPostId());
        }
        return (count = this.sysPostMapper.selectCount((Wrapper)wrapper).longValue()) > 0L;
    }

    @Override
    public boolean checkPostCodeUnique(SysPost post) {
        long count;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysPost::getPostCode, (Object)post.getPostCode());
        if (post.getPostId() != null && post.getPostId() > 0L) {
            wrapper.ne(SysPost::getPostId, (Object)post.getPostId());
        }
        return (count = this.sysPostMapper.selectCount((Wrapper)wrapper).longValue()) > 0L;
    }

    @Override
    public List<Long> selectPostListByUserId(Long userId) {
        return this.sysPostMapper.selectPostListByUserId(userId);
    }

    public SysPostServiceImpl(SysPostMapper sysPostMapper, SysUserPostMapper sysUserPostMapper) {
        this.sysPostMapper = sysPostMapper;
        this.sysUserPostMapper = sysUserPostMapper;
    }
}

