/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.common.domain.TreeSelect;
import cn.morethank.open.admin.common.util.RequestUtil;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysMenu;
import cn.morethank.open.admin.system.domain.SysRole;
import cn.morethank.open.admin.system.domain.SysUser;
import cn.morethank.open.admin.system.mapper.SysMenuMapper;
import cn.morethank.open.admin.system.mapper.SysRoleMapper;
import cn.morethank.open.admin.system.service.SysMenuService;
import cn.morethank.open.admin.system.vo.MetaVo;
import cn.morethank.open.admin.system.vo.RouterVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SysMenuServiceImpl
extends ServiceImpl<SysMenuMapper, SysMenu>
implements SysMenuService {
    private final SysMenuMapper sysMenuMapper;
    private final SysRoleMapper sysRoleMapper;

    @Override
    public IPage<SysMenu> selectListPage(Page<SysMenu> page, LambdaQueryWrapper<SysMenu> query) {
        return this.sysMenuMapper.selectPage((IPage)page, (Wrapper)query);
    }

    @Override
    public Set<String> selectMenuPermsByRoleId(Long roleId) {
        List<String> perms = this.sysMenuMapper.selectMenuPermsByRoleId(roleId);
        HashSet<String> permsSet = new HashSet<String>();
        for (String perm : perms) {
            if (!StringUtils.isNotEmpty(perm)) continue;
            permsSet.addAll(Arrays.asList(perm.trim().split(",")));
        }
        return permsSet;
    }

    @Override
    public Set<String> selectMenuPermsByUserId(Long userId) {
        List<String> perms = this.sysMenuMapper.selectMenuPermsByUserId(userId);
        HashSet<String> permsSet = new HashSet<String>();
        for (String perm : perms) {
            if (!StringUtils.isNotEmpty(perm)) continue;
            permsSet.addAll(Arrays.asList(perm.trim().split(",")));
        }
        return permsSet;
    }

    @Override
    public List<SysMenu> selectMenuTreeByUserId(Long userId) {
        List<SysMenu> menus = null;
        menus = userId != null && 1L == userId ? this.sysMenuMapper.selectMenuTreeAll() : this.sysMenuMapper.selectMenuTreeByUserId(userId);
        return this.getChildPerms(menus, 0);
    }

    @Override
    public List<RouterVo> buildMenus(List<SysMenu> menus) {
        LinkedList<RouterVo> routers = new LinkedList<RouterVo>();
        for (SysMenu menu : menus) {
            RouterVo children;
            ArrayList<RouterVo> childrenList;
            RouterVo router = new RouterVo();
            router.setHidden("1".equals(menu.getVisible()));
            router.setName(this.getRouteName(menu));
            router.setPath(this.getRouterPath(menu));
            router.setComponent(this.getComponent(menu));
            router.setQuery(menu.getQuery());
            router.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon(), StringUtils.equals((CharSequence)"1", (CharSequence)menu.getIsCache()), menu.getPath()));
            List<SysMenu> cMenus = menu.getChildren();
            if (!cMenus.isEmpty() && cMenus.size() > 0 && "M".equals(menu.getMenuType())) {
                router.setAlwaysShow(true);
                router.setRedirect("noRedirect");
                router.setChildren(this.buildMenus(cMenus));
            } else if (this.isMenuFrame(menu)) {
                router.setMeta(null);
                childrenList = new ArrayList<RouterVo>();
                children = new RouterVo();
                children.setPath(menu.getPath());
                children.setComponent(menu.getComponent());
                children.setName(StringUtils.capitalize((String)menu.getPath()));
                children.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon(), StringUtils.equals((CharSequence)"1", (CharSequence)menu.getIsCache()), menu.getPath()));
                children.setQuery(menu.getQuery());
                childrenList.add(children);
                router.setChildren(childrenList);
            } else if (menu.getParentId().intValue() == 0 && this.isInnerLink(menu)) {
                router.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon()));
                router.setPath("/");
                childrenList = new ArrayList();
                children = new RouterVo();
                String routerPath = this.innerLinkReplaceEach(menu.getPath());
                children.setPath(routerPath);
                children.setComponent("InnerLink");
                children.setName(StringUtils.capitalize((String)routerPath));
                children.setMeta(new MetaVo(menu.getMenuName(), menu.getIcon(), menu.getPath()));
                childrenList.add(children);
                router.setChildren(childrenList);
            }
            routers.add(router);
        }
        return routers;
    }

    @Override
    public List<SysMenu> selectMenuList(SysUser user) {
        return this.selectMenuList(new SysMenu(), user);
    }

    @Override
    public List<SysMenu> selectMenuList(SysMenu menu, SysUser user) {
        List menuList;
        if (user.isAdmin()) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            if (!RequestUtil.isEmpty(menu.getMenuName())) {
                queryWrapper.like(SysMenu::getMenuName, (Object)menu.getMenuName());
            }
            if (!RequestUtil.isEmpty(menu.getVisible())) {
                queryWrapper.eq(SysMenu::getVisible, (Object)menu.getVisible());
            }
            if (!RequestUtil.isEmpty(menu.getStatus())) {
                queryWrapper.eq(SysMenu::getStatus, (Object)menu.getStatus());
            }
            menuList = this.sysMenuMapper.selectList((Wrapper)queryWrapper);
        } else {
            menu.getParams().put("userId", user.getUserId());
            menuList = this.sysMenuMapper.selectMenuListByUserId(menu);
        }
        return menuList;
    }

    @Override
    public List<TreeSelect> buildMenuTreeSelect(List<SysMenu> menus) {
        List<SysMenu> menuTrees = this.buildMenuTree(menus);
        return menuTrees.stream().map(TreeSelect::new).collect(Collectors.toList());
    }

    @Override
    public List<SysMenu> buildMenuTree(List<SysMenu> menus) {
        List<SysMenu> returnList = new ArrayList<SysMenu>();
        ArrayList<Long> tempList = new ArrayList<Long>();
        for (SysMenu dept : menus) {
            tempList.add(dept.getMenuId());
        }
        for (SysMenu menu : menus) {
            if (tempList.contains(menu.getParentId())) continue;
            this.recursionFn(menus, menu);
            returnList.add(menu);
        }
        if (returnList.isEmpty()) {
            returnList = menus;
        }
        return returnList;
    }

    @Override
    public List<Long> selectMenuListByRoleId(Long roleId) {
        SysRole role = (SysRole)this.sysRoleMapper.selectById(roleId);
        return this.sysMenuMapper.selectMenuListByRoleId(roleId, role.isMenuCheckStrictly());
    }

    @Override
    public List<SysMenu> selectMenuListByUserId(SysMenu sysMenu) {
        return this.sysMenuMapper.selectMenuListByUserId(sysMenu);
    }

    @Override
    public boolean checkMenuNameUnique(SysMenu menu) {
        long count;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysMenu::getMenuName, (Object)menu.getMenuName())).eq(SysMenu::getParentId, (Object)menu.getParentId());
        if (menu.getMenuId() != null && menu.getMenuId() > 0L) {
            wrapper.ne(SysMenu::getMenuId, (Object)menu.getMenuId());
        }
        return (count = this.sysMenuMapper.selectCount((Wrapper)wrapper).longValue()) > 0L;
    }

    @Override
    public boolean hasChildByMenuId(Long menuId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysMenu::getParentId, (Object)menuId);
        long count = this.sysMenuMapper.selectCount((Wrapper)wrapper);
        return count > 0L;
    }

    @Override
    public boolean checkMenuExistRole(Long menuId) {
        int count = this.sysMenuMapper.checkMenuExistRole(menuId);
        return count > 0;
    }

    public List<SysMenu> getChildPerms(List<SysMenu> list, int parentId) {
        ArrayList<SysMenu> returnList = new ArrayList<SysMenu>();
        for (SysMenu t : list) {
            if (t.getParentId() != (long)parentId) continue;
            this.recursionFn(list, t);
            returnList.add(t);
        }
        return returnList;
    }

    private void recursionFn(List<SysMenu> list, SysMenu t) {
        List<SysMenu> childList = this.getChildList(list, t);
        t.setChildren(childList);
        for (SysMenu tChild : childList) {
            if (!this.hasChild(list, tChild)) continue;
            this.recursionFn(list, tChild);
        }
    }

    private List<SysMenu> getChildList(List<SysMenu> list, SysMenu t) {
        ArrayList<SysMenu> tlist = new ArrayList<SysMenu>();
        for (SysMenu n : list) {
            if (n.getParentId().longValue() != t.getMenuId().longValue()) continue;
            tlist.add(n);
        }
        return tlist;
    }

    private boolean hasChild(List<SysMenu> list, SysMenu t) {
        return this.getChildList(list, t).size() > 0;
    }

    public String getRouteName(SysMenu menu) {
        String routerName = StringUtils.capitalize((String)menu.getPath());
        if (this.isMenuFrame(menu)) {
            routerName = "";
        }
        return routerName;
    }

    public String getRouterPath(SysMenu menu) {
        String routerPath = menu.getPath();
        if (menu.getParentId().intValue() != 0 && this.isInnerLink(menu)) {
            routerPath = this.innerLinkReplaceEach(routerPath);
        }
        if (0 == menu.getParentId().intValue() && "M".equals(menu.getMenuType()) && "1".equals(menu.getIsFrame())) {
            routerPath = "/" + menu.getPath();
        } else if (this.isMenuFrame(menu)) {
            routerPath = "/";
        }
        return routerPath;
    }

    public String getComponent(SysMenu menu) {
        String component = "Layout";
        if (StringUtils.isNotEmpty(menu.getComponent()) && !this.isMenuFrame(menu)) {
            component = menu.getComponent();
        } else if (StringUtils.isEmpty(menu.getComponent()) && menu.getParentId().intValue() != 0 && this.isInnerLink(menu)) {
            component = "InnerLink";
        } else if (StringUtils.isEmpty(menu.getComponent()) && this.isParentView(menu)) {
            component = "ParentView";
        }
        return component;
    }

    public boolean isMenuFrame(SysMenu menu) {
        return menu.getParentId().intValue() == 0 && "C".equals(menu.getMenuType()) && menu.getIsFrame().equals("1");
    }

    public boolean isInnerLink(SysMenu menu) {
        return menu.getIsFrame().equals("1") && StringUtils.ishttp(menu.getPath());
    }

    public boolean isParentView(SysMenu menu) {
        return menu.getParentId().intValue() != 0 && "M".equals(menu.getMenuType());
    }

    public String innerLinkReplaceEach(String path) {
        return StringUtils.replaceEach((String)path, (String[])new String[]{"http://", "https://", "www.", "."}, (String[])new String[]{"", "", "", "/"});
    }

    public SysMenuServiceImpl(SysMenuMapper sysMenuMapper, SysRoleMapper sysRoleMapper) {
        this.sysMenuMapper = sysMenuMapper;
        this.sysRoleMapper = sysRoleMapper;
    }
}

