/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.common.exception.ServiceException;
import cn.morethank.open.admin.common.util.DictUtils;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysDictData;
import cn.morethank.open.admin.system.domain.SysDictType;
import cn.morethank.open.admin.system.mapper.SysDictDataMapper;
import cn.morethank.open.admin.system.mapper.SysDictTypeMapper;
import cn.morethank.open.admin.system.service.SysDictTypeService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SysDictTypeServiceImpl
extends ServiceImpl<SysDictTypeMapper, SysDictType>
implements SysDictTypeService {
    private final SysDictTypeMapper sysDictTypeMapper;
    private final SysDictDataMapper dictDataMapper;
    private final DictUtils dictUtils;

    @Override
    public IPage<SysDictType> selectListPage(Page<SysDictType> page, LambdaQueryWrapper<SysDictType> query) {
        return this.sysDictTypeMapper.selectPage((IPage)page, (Wrapper)query);
    }

    @Override
    public List<SysDictData> selectDictDataByType(String dictType) {
        List<SysDictData> dictDatas = this.dictUtils.getDictCache(dictType);
        if (StringUtils.isNotEmpty(dictDatas)) {
            return dictDatas;
        }
        dictDatas = this.dictDataMapper.selectDictDataByType(dictType);
        if (StringUtils.isNotEmpty(dictDatas)) {
            this.dictUtils.setDictCache(dictType, dictDatas);
            return dictDatas;
        }
        return null;
    }

    @Override
    public int deleteDictTypeByIds(Long[] dictIds) {
        for (Long dictId : dictIds) {
            SysDictType dictType = (SysDictType)this.getById(dictId);
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysDictData::getDictType, (Object)dictType.getDictType());
            long useCount = this.dictDataMapper.selectCount((Wrapper)query);
            if (useCount > 0L) {
                throw new ServiceException(String.format("%1$s\u5df2\u5206\u914d,\u4e0d\u80fd\u5220\u9664", dictType.getDictName()));
            }
            this.sysDictTypeMapper.deleteById(dictId);
            this.dictUtils.removeDictCache(dictType.getDictType());
        }
        return dictIds.length;
    }

    @Override
    public boolean checkDictTypeUnique(SysDictType dict) {
        long count;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysDictType::getDictType, (Object)dict.getDictType());
        if (dict.getDictId() != null && dict.getDictId() > 0L) {
            wrapper.ne(SysDictType::getDictId, (Object)dict.getDictId());
        }
        return (count = this.sysDictTypeMapper.selectCount((Wrapper)wrapper).longValue()) > 0L;
    }

    @Override
    public void resetDictCache() {
        this.dictUtils.clearDictCache();
        this.loadingDictCache();
    }

    private void loadingDictCache() {
        SysDictData dictData = new SysDictData();
        dictData.setStatus("0");
        Map<String, List<SysDictData>> dictDataMap = this.dictDataMapper.selectDictDataList(dictData).stream().collect(Collectors.groupingBy(SysDictData::getDictType));
        for (Map.Entry<String, List<SysDictData>> entry : dictDataMap.entrySet()) {
            this.dictUtils.setDictCache(entry.getKey(), entry.getValue().stream().sorted(Comparator.comparing(SysDictData::getDictSort)).collect(Collectors.toList()));
        }
    }

    public SysDictTypeServiceImpl(SysDictTypeMapper sysDictTypeMapper, SysDictDataMapper dictDataMapper, DictUtils dictUtils) {
        this.sysDictTypeMapper = sysDictTypeMapper;
        this.dictDataMapper = dictDataMapper;
        this.dictUtils = dictUtils;
    }
}

