/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.common.util.DictUtils;
import cn.morethank.open.admin.system.domain.SysDictData;
import cn.morethank.open.admin.system.mapper.SysDictDataMapper;
import cn.morethank.open.admin.system.service.SysDictDataService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysDictDataServiceImpl
extends ServiceImpl<SysDictDataMapper, SysDictData>
implements SysDictDataService {
    private final SysDictDataMapper sysDictDataMapper;
    private final DictUtils dictUtils;

    @Override
    public IPage<SysDictData> selectListPage(Page<SysDictData> page, LambdaQueryWrapper<SysDictData> query) {
        return this.sysDictDataMapper.selectPage((IPage)page, (Wrapper)query);
    }

    @Override
    public void deleteDictDataByIds(Long[] dictCodes) {
        for (Long dictCode : dictCodes) {
            SysDictData data = (SysDictData)this.getById(dictCode);
            this.sysDictDataMapper.deleteById(dictCode);
            List<SysDictData> dictDatas = this.sysDictDataMapper.selectDictDataByType(data.getDictType());
            this.dictUtils.setDictCache(data.getDictType(), dictDatas);
        }
    }

    public SysDictDataServiceImpl(SysDictDataMapper sysDictDataMapper, DictUtils dictUtils) {
        this.sysDictDataMapper = sysDictDataMapper;
        this.dictUtils = dictUtils;
    }
}

