/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.common.domain.TreeSelect;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysDept;
import cn.morethank.open.admin.system.domain.SysRole;
import cn.morethank.open.admin.system.domain.SysUser;
import cn.morethank.open.admin.system.mapper.SysDeptMapper;
import cn.morethank.open.admin.system.mapper.SysRoleMapper;
import cn.morethank.open.admin.system.mapper.SysUserMapper;
import cn.morethank.open.admin.system.service.SysDeptService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SysDeptServiceImpl
extends ServiceImpl<SysDeptMapper, SysDept>
implements SysDeptService {
    private final SysDeptMapper sysDeptMapper;
    private final SysUserMapper sysUserMapper;
    private final SysRoleMapper sysRoleMapper;

    @Override
    public boolean checkDeptNameUnique(SysDept dept) {
        long count;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysDept::getDeptName, (Object)dept.getDeptName())).eq(SysDept::getParentId, (Object)dept.getParentId())).eq(SysDept::getDelFlag, (Object)"0");
        if (dept.getDeptId() != null && dept.getDeptId() > 0L) {
            wrapper.ne(SysDept::getDeptId, (Object)dept.getDeptId());
        }
        return (count = this.sysDeptMapper.selectCount((Wrapper)wrapper).longValue()) > 0L;
    }

    @Override
    public int deleteDeptById(Long deptId) {
        SysDept dept = new SysDept();
        dept.setDeptId(deptId);
        dept.setDelFlag("2");
        return this.sysDeptMapper.updateById(dept);
    }

    @Override
    public boolean hasChildByDeptId(Long deptId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysDept::getParentId, (Object)deptId)).eq(SysDept::getDelFlag, (Object)"0");
        long count = this.sysDeptMapper.selectCount((Wrapper)wrapper);
        return count > 0L;
    }

    @Override
    public boolean checkDeptExistUser(Long deptId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysUser::getDeptId, (Object)deptId)).eq(SysUser::getDelFlag, (Object)"0");
        long count = this.sysUserMapper.selectCount((Wrapper)wrapper);
        return count > 0L;
    }

    @Override
    public int selectNormalChildrenDeptById(Long deptId) {
        return this.sysUserMapper.selectNormalChildrenDeptById(deptId);
    }

    @Override
    public List<SysDept> selectDeptList(SysDept dept) {
        return this.sysDeptMapper.selectDeptList(dept);
    }

    @Override
    public List<TreeSelect> selectDeptTreeList(SysDept dept) {
        List<SysDept> depts = this.selectDeptList(dept);
        return this.buildDeptTreeSelect(depts);
    }

    @Override
    public List<TreeSelect> buildDeptTreeSelect(List<SysDept> depts) {
        List<SysDept> deptTrees = this.buildDeptTree(depts);
        return deptTrees.stream().map(TreeSelect::new).collect(Collectors.toList());
    }

    @Override
    public List<SysDept> buildDeptTree(List<SysDept> depts) {
        List<SysDept> returnList = new ArrayList<SysDept>();
        ArrayList<Long> tempList = new ArrayList<Long>();
        for (SysDept dept : depts) {
            tempList.add(dept.getDeptId());
        }
        for (SysDept dept : depts) {
            if (tempList.contains(dept.getParentId())) continue;
            this.recursionFn(depts, dept);
            returnList.add(dept);
        }
        if (returnList.isEmpty()) {
            returnList = depts;
        }
        return returnList;
    }

    @Override
    public List<Long> selectDeptListByRoleId(Long roleId) {
        SysRole role = (SysRole)this.sysRoleMapper.selectById(roleId);
        return this.sysDeptMapper.selectDeptListByRoleId(roleId, role.isDeptCheckStrictly());
    }

    private void recursionFn(List<SysDept> list, SysDept t) {
        List<SysDept> childList = this.getChildList(list, t);
        t.setChildren(childList);
        for (SysDept tChild : childList) {
            if (!this.hasChild(list, tChild)) continue;
            this.recursionFn(list, tChild);
        }
    }

    private List<SysDept> getChildList(List<SysDept> list, SysDept t) {
        ArrayList<SysDept> tlist = new ArrayList<SysDept>();
        for (SysDept n : list) {
            if (!StringUtils.isNotNull(n.getParentId()) || n.getParentId().longValue() != t.getDeptId().longValue()) continue;
            tlist.add(n);
        }
        return tlist;
    }

    private boolean hasChild(List<SysDept> list, SysDept t) {
        return this.getChildList(list, t).size() > 0;
    }

    public SysDeptServiceImpl(SysDeptMapper sysDeptMapper, SysUserMapper sysUserMapper, SysRoleMapper sysRoleMapper) {
        this.sysDeptMapper = sysDeptMapper;
        this.sysUserMapper = sysUserMapper;
        this.sysRoleMapper = sysRoleMapper;
    }
}

