/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.service.impl;

import cn.morethank.open.admin.common.exception.ServiceException;
import cn.morethank.open.admin.common.service.RedisService;
import cn.morethank.open.admin.common.util.Convert;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysConfig;
import cn.morethank.open.admin.system.mapper.SysConfigMapper;
import cn.morethank.open.admin.system.service.SysConfigService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SysConfigServiceImpl
extends ServiceImpl<SysConfigMapper, SysConfig>
implements SysConfigService {
    private final SysConfigMapper sysConfigMapper;
    private final RedisService redisService;

    @Override
    public IPage<SysConfig> selectListPage(Page<SysConfig> page, LambdaQueryWrapper<SysConfig> query) {
        return this.sysConfigMapper.selectPage((IPage)page, (Wrapper)query);
    }

    @Override
    public int deleteConfigByIds(Long[] configIds) {
        for (Long configId : configIds) {
            SysConfig config = (SysConfig)this.getById(configId);
            if (StringUtils.equals((CharSequence)"Y", (CharSequence)config.getConfigType())) {
                throw new ServiceException(String.format("\u5185\u7f6e\u53c2\u6570\u3010%1$s\u3011\u4e0d\u80fd\u5220\u9664 ", config.getConfigKey()));
            }
            this.sysConfigMapper.deleteById(configId);
            this.redisService.del(this.getCacheKey(config.getConfigKey()));
        }
        return configIds.length;
    }

    @Override
    public void resetConfigCache() {
        this.clearConfigCache();
        this.loadingConfigCache();
    }

    @Override
    public void clearConfigCache() {
        Collection<String> keys = this.redisService.keys("sys_config:*");
        this.redisService.deleteObjects(keys);
    }

    @Override
    public void loadingConfigCache() {
        QueryWrapper queryWrapper = new QueryWrapper();
        List configsList = this.sysConfigMapper.selectList((Wrapper)queryWrapper);
        for (SysConfig config : configsList) {
            this.redisService.set(this.getCacheKey(config.getConfigKey()), config.getConfigValue());
        }
    }

    @Override
    public boolean checkConfigKeyUnique(SysConfig config) {
        long count;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysConfig::getConfigKey, (Object)config.getConfigKey());
        if (config.getConfigId() != null && (long)config.getConfigId().intValue() > 0L) {
            wrapper.ne(SysConfig::getConfigId, (Object)config.getConfigId());
        }
        return (count = this.sysConfigMapper.selectCount((Wrapper)wrapper).longValue()) > 0L;
    }

    @Override
    public Object selectConfigByKey(String configKey) {
        String configValue = Convert.toStr(this.redisService.get(this.getCacheKey(configKey)));
        if (StringUtils.isNotEmpty(configValue)) {
            return configValue;
        }
        SysConfig config = new SysConfig();
        config.setConfigKey(configKey);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysConfig::getConfigKey, (Object)config.getConfigKey());
        SysConfig retConfig = (SysConfig)this.sysConfigMapper.selectOne((Wrapper)wrapper);
        if (StringUtils.isNotNull(retConfig)) {
            this.redisService.set(this.getCacheKey(configKey), retConfig.getConfigValue());
            return retConfig.getConfigValue();
        }
        return "";
    }

    private String getCacheKey(String configKey) {
        return "sys_config:" + configKey;
    }

    public SysConfigServiceImpl(SysConfigMapper sysConfigMapper, RedisService redisService) {
        this.sysConfigMapper = sysConfigMapper;
        this.redisService = redisService;
    }
}

