/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.service;

import cn.morethank.open.admin.system.domain.SysRole;
import cn.morethank.open.admin.system.domain.SysUser;
import cn.morethank.open.admin.system.service.SysMenuService;
import cn.morethank.open.admin.system.service.SysRoleService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysPermissionService {
    private static final Logger log = LoggerFactory.getLogger(SysPermissionService.class);
    private final SysRoleService sysRoleService;
    private final SysMenuService sysMenuService;

    public Set<String> getRolePermission(SysUser user) {
        HashSet<String> roles = new HashSet<String>();
        if (user.isAdmin()) {
            roles.add("admin");
        } else {
            roles.addAll(this.sysRoleService.selectRolePermissionByUserId(user.getUserId()));
        }
        return roles;
    }

    public Set<String> getMenuPermission(SysUser user) {
        HashSet<String> perms = new HashSet<String>();
        if (user.isAdmin()) {
            perms.add("*:*:*");
        } else {
            List<SysRole> roles = user.getRoles();
            if (roles != null && !roles.isEmpty() && roles.size() > 1) {
                for (SysRole role : roles) {
                    Set<String> rolePerms = this.sysMenuService.selectMenuPermsByRoleId(role.getRoleId());
                    role.setPermissions(rolePerms);
                    perms.addAll(rolePerms);
                }
            } else {
                perms.addAll(this.sysMenuService.selectMenuPermsByUserId(user.getUserId()));
            }
        }
        return perms;
    }

    public SysPermissionService(SysRoleService sysRoleService, SysMenuService sysMenuService) {
        this.sysRoleService = sysRoleService;
        this.sysMenuService = sysMenuService;
    }
}

