/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.controller;

import cn.morethank.open.admin.common.annotation.OperateLog;
import cn.morethank.open.admin.common.config.AdminConfig;
import cn.morethank.open.admin.common.domain.AppConstant;
import cn.morethank.open.admin.common.domain.BusinessType;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.security.AccountUser;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.common.util.FileUploadUtils;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysDept;
import cn.morethank.open.admin.system.domain.SysRole;
import cn.morethank.open.admin.system.domain.SysUser;
import cn.morethank.open.admin.system.service.SysDeptService;
import cn.morethank.open.admin.system.service.SysPostService;
import cn.morethank.open.admin.system.service.SysRoleService;
import cn.morethank.open.admin.system.service.SysUserService;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/system/user"})
public class SysUserController {
    private static final Logger log = LoggerFactory.getLogger(SysUserController.class);
    private final SysUserService sysUserService;
    private final SysDeptService sysDeptService;
    private final SysRoleService sysRoleService;
    private final SysPostService sysPostService;
    private final JwtService jwtService;

    @OperateLog(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.DETAIL)
    @PreAuthorize(value="@auth.hasAuthority('system:user:query')")
    @GetMapping(value={"/", "/{id}"})
    public Result detail(@PathVariable(value="id", required=false) Long id) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByAsc(SysRole::getRoleSort);
        List roles = this.sysRoleService.list((Wrapper)queryWrapper);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("roles", SysUser.isAdmin(id) ? roles : roles.stream().filter(r -> !r.isAdmin()).collect(Collectors.toList()));
        dataMap.put("posts", this.sysPostService.list());
        if (StringUtils.isNotNull(id)) {
            SysUser sysUser = this.sysUserService.selectUserById(id);
            dataMap.put("user", sysUser);
            dataMap.put("postIds", this.sysPostService.selectPostListByUserId(id));
            dataMap.put("roleIds", sysUser.getRoles().stream().map(SysRole::getRoleId).collect(Collectors.toList()));
        }
        return Result.succ(dataMap);
    }

    @OperateLog(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.LIST)
    @PreAuthorize(value="@auth.hasAuthority('system:user:list')")
    @GetMapping(value={"/list"})
    public Result list(SysUser sysUser, @RequestParam(name="pageNum", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        log.info("\u5206\u9875\u67e5\u8be2sysUser,\u68c0\u7d22\u53c2\u6570sysUser={},\u5206\u9875\u53c2\u6570pageNo={},pageSize={}", new Object[]{sysUser, pageNo, pageSize});
        try {
            Page page = PageDTO.of((long)pageNo.intValue(), (long)pageSize.intValue());
            IPage<SysUser> pageList = this.sysUserService.selectListPage((Page<SysUser>)page, sysUser);
            log.info("\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c:{}", pageList);
            return Result.succ(pageList);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @OperateLog(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.DELETE)
    @PreAuthorize(value="@auth.hasAuthority('system:user:remove')")
    @DeleteMapping(value={"/{userIds}"})
    public Result remove(@PathVariable Long[] userIds) {
        Long loginUserId = this.jwtService.getLoginUser().getUserId();
        if (ArrayUtils.contains((Object[])userIds, (Object)loginUserId)) {
            return Result.fail("\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u5220\u9664");
        }
        return Result.succ(this.sysUserService.deleteUserByIds(userIds));
    }

    @OperateLog(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PreAuthorize(value="@auth.hasAuthority('system:user:add')")
    @PostMapping
    public Result add(@Validated @RequestBody SysUser user) {
        if (this.sysUserService.checkUserNameUnique(user.getUserName())) {
            return Result.fail("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty(user.getPhonenumber()) && this.sysUserService.checkPhoneUnique(user)) {
            return Result.fail("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty(user.getEmail()) && this.sysUserService.checkEmailUnique(user)) {
            return Result.fail("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        user.setCreateBy(this.jwtService.getUserName());
        user.setCreateTime(LocalDateTime.now());
        return Result.succ(this.sysUserService.insertUser(user));
    }

    @OperateLog(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PreAuthorize(value="@auth.hasAuthority('system:user:edit')")
    @PutMapping
    public Result edit(@Validated @RequestBody SysUser user) {
        this.sysUserService.checkUserAllowed(user);
        if (StringUtils.isNotEmpty(user.getPhonenumber()) && this.sysUserService.checkPhoneUnique(user)) {
            return Result.fail("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty(user.getEmail()) && this.sysUserService.checkEmailUnique(user)) {
            return Result.fail("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        user.setUpdateBy(this.jwtService.getUserName());
        user.setUpdateTime(LocalDateTime.now());
        return Result.succ(this.sysUserService.updateUser(user));
    }

    @OperateLog(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PreAuthorize(value="@auth.hasAuthority('system:user:resetPwd')")
    @PutMapping(value={"/resetPwd"})
    public Result resetPwd(@RequestBody SysUser user) {
        this.sysUserService.checkUserAllowed(user);
        user.setUpdateBy(this.jwtService.getUserName());
        user.setUpdateTime(LocalDateTime.now());
        return Result.succ(this.sysUserService.resetPwd(user));
    }

    @OperateLog(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.LIST)
    @PreAuthorize(value="@auth.hasAuthority('system:user:list')")
    @GetMapping(value={"/deptTree"})
    public Result deptTree(SysDept dept) {
        return Result.succ(this.sysDeptService.selectDeptTreeList(dept));
    }

    @OperateLog(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.DETAIL)
    @PreAuthorize(value="@auth.hasAuthority('system:user:query')")
    @GetMapping(value={"/authRole/{userId}"})
    public Result authRole(@PathVariable(value="userId") Long userId) {
        SysUser user = this.sysUserService.selectUserById(userId);
        List<SysRole> roles = this.sysRoleService.selectRolesByUserId(userId);
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("user", user);
        data.put("roles", SysUser.isAdmin(userId) ? roles : roles.stream().filter(r -> !r.isAdmin()).collect(Collectors.toList()));
        return Result.succ(data);
    }

    @OperateLog(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.GRANT)
    @PreAuthorize(value="@auth.hasAuthority('system:user:edit')")
    @PutMapping(value={"/authRole"})
    public Result insertAuthRole(Long userId, Long[] roleIds) {
        this.sysUserService.insertUserAuth(userId, roleIds);
        return Result.success();
    }

    @PreAuthorize(value="@auth.hasAuthority('system:user:edit')")
    @OperateLog(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/changeStatus"})
    public Result changeStatus(@RequestBody SysUser user) {
        this.sysUserService.checkUserAllowed(user);
        this.sysUserService.checkUserDataScope(user.getUserId());
        user.setUpdateBy(this.jwtService.getUserName());
        user.setUpdateTime(LocalDateTime.now());
        return Result.succ(this.sysUserService.updateUser(user));
    }

    @OperateLog(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @PreAuthorize(value="@auth.hasAuthority('system:user:export')")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysUser user) throws IOException {
        List<SysUser> list = this.sysUserService.selectUserList(user);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u7528\u6237", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), SysUser.class).sheet("\u7528\u6237").doWrite(list);
    }

    @OperateLog(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.DETAIL)
    @PreAuthorize(value="@auth.hasAuthority('system:user:query')")
    @GetMapping(value={"/profile"})
    public Result profile(HttpServletRequest request) {
        AccountUser user = this.jwtService.getLoginUser(request);
        SysUser sysUser = user.getUser();
        HashMap<String, Object> ajax = new HashMap<String, Object>(3);
        ajax.put("user", sysUser);
        ajax.put("roleGroup", this.sysUserService.selectUserRoleGroup(sysUser.getUserName()));
        ajax.put("postGroup", this.sysUserService.selectUserPostGroup(sysUser.getUserName()));
        return Result.succ(ajax);
    }

    @OperateLog(title="\u4e2a\u4eba\u4fe1\u606f", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/profile"})
    public Result updateProfile(@RequestBody SysUser user, HttpServletRequest request) {
        AccountUser loginUser = this.jwtService.getLoginUser(request);
        SysUser sysUser = loginUser.getUser();
        user.setUserName(sysUser.getUserName());
        if (StringUtils.isNotEmpty(user.getPhonenumber()) && this.sysUserService.checkPhoneUnique(user)) {
            return Result.fail("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty(user.getEmail()) && this.sysUserService.checkEmailUnique(user)) {
            return Result.fail("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        user.setUserId(sysUser.getUserId());
        user.setPassword(null);
        user.setAvatar(null);
        user.setDeptId(null);
        user.setUpdateBy(this.jwtService.getUserName());
        user.setUpdateTime(LocalDateTime.now());
        if (this.sysUserService.updateUser(user) > 0) {
            sysUser.setNickName(user.getNickName());
            sysUser.setPhonenumber(user.getPhonenumber());
            sysUser.setEmail(user.getEmail());
            sysUser.setSex(user.getSex());
            this.jwtService.setLoginUser(loginUser);
            return Result.success();
        }
        return Result.error("\u4fee\u6539\u4e2a\u4eba\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @OperateLog(title="\u7528\u6237\u5934\u50cf", businessType=BusinessType.UPDATE)
    @PostMapping(value={"/profile/avatar"})
    public Result avatar(@RequestParam(value="avatarfile") MultipartFile file, HttpServletRequest request) throws Exception {
        if (!file.isEmpty()) {
            AccountUser loginUser = this.jwtService.getLoginUser(request);
            String avatar = FileUploadUtils.upload(AdminConfig.getAvatarPath(), file, AppConstant.IMAGE_EXTENSION);
            if (this.sysUserService.updateUserAvatar(loginUser.getUsername(), avatar)) {
                loginUser.getUser().setAvatar(avatar);
                this.jwtService.setLoginUser(loginUser);
                return Result.succ(avatar);
            }
        }
        return Result.error("\u4e0a\u4f20\u56fe\u7247\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    public SysUserController(SysUserService sysUserService, SysDeptService sysDeptService, SysRoleService sysRoleService, SysPostService sysPostService, JwtService jwtService) {
        this.sysUserService = sysUserService;
        this.sysDeptService = sysDeptService;
        this.sysRoleService = sysRoleService;
        this.sysPostService = sysPostService;
        this.jwtService = jwtService;
    }
}

