/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.controller;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.annotation.OperateLog;
import cn.morethank.open.admin.common.domain.BusinessType;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.security.AccountUser;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.common.util.QueryWrapperUtil;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysDept;
import cn.morethank.open.admin.system.domain.SysRole;
import cn.morethank.open.admin.system.domain.SysUser;
import cn.morethank.open.admin.system.domain.SysUserRole;
import cn.morethank.open.admin.system.service.SysDeptService;
import cn.morethank.open.admin.system.service.SysPermissionService;
import cn.morethank.open.admin.system.service.SysRoleService;
import cn.morethank.open.admin.system.service.SysUserService;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/role"})
public class SysRoleController {
    private static final Logger log = LoggerFactory.getLogger(SysRoleController.class);
    private final SysUserService sysUserService;
    private final SysRoleService sysRoleService;
    private final SysDeptService sysDeptService;
    private final SysPermissionService sysPermissionService;
    private final JwtService jwtService;

    @OperateLog(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.DETAIL)
    @RequestMapping(value={"{id}"})
    @PreAuthorize(value="@auth.hasAuthority('system:role:query')")
    public Result detail(@PathVariable Long id) {
        SysRole sysRole = (SysRole)this.sysRoleService.getById(id);
        return Result.succ(sysRole);
    }

    @OperateLog(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.LIST)
    @PreAuthorize(value="@auth.hasAuthority('system:role:query')")
    @GetMapping(value={"/list"})
    public Result list(SysRole sysRole, @RequestParam(name="pageNum", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        log.info("\u5206\u9875\u67e5\u8be2sysRole,\u68c0\u7d22\u53c2\u6570sysRole={},\u5206\u9875\u53c2\u6570pageNo={},pageSize={}", new Object[]{sysRole, pageNo, pageSize});
        try {
            LambdaQueryWrapper<SysRole> query = this.getQueryWrapper(sysRole);
            IPage<SysRole> pageList = this.sysRoleService.selectListPage((Page<SysRole>)new Page((long)pageNo.intValue(), (long)pageSize.intValue()), query);
            log.info("\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c:{}", pageList);
            return Result.succ(pageList);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @OperateLog(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PreAuthorize(value="@auth.hasAuthority('system:role:edit')")
    @PutMapping(value={"/changeStatus"})
    public Result changeStatus(@RequestBody SysRole role) {
        this.sysRoleService.checkRoleAllowed(role);
        return Result.succ(this.sysRoleService.updateRoleStatus(role));
    }

    @OperateLog(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.DELETE)
    @PreAuthorize(value="@auth.hasAuthority('system:role:remove')")
    @DeleteMapping(value={"/{roleIds}"})
    public Result remove(@PathVariable Long[] roleIds) {
        return Result.succ(this.sysRoleService.deleteRoleByIds(roleIds));
    }

    @OperateLog(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PreAuthorize(value="@auth.hasAuthority('system:role:add')")
    @PostMapping
    public Result add(@Validated @RequestBody SysRole role) {
        if (this.sysRoleService.checkRoleNameUnique(role)) {
            return Result.fail("\u65b0\u589e\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (this.sysRoleService.checkRoleKeyUnique(role)) {
            return Result.fail("\u65b0\u589e\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u6743\u9650\u5df2\u5b58\u5728");
        }
        role.setCreateBy(this.jwtService.getUserName());
        role.setCreateTime(LocalDateTime.now());
        return Result.succ(this.sysRoleService.insertRole(role));
    }

    @OperateLog(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PreAuthorize(value="@auth.hasAuthority('system:role:edit')")
    @PutMapping
    public Result edit(@Validated @RequestBody SysRole role) {
        this.sysRoleService.checkRoleAllowed(role);
        if (this.sysRoleService.checkRoleNameUnique(role)) {
            return Result.fail("\u4fee\u6539\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (this.sysRoleService.checkRoleKeyUnique(role)) {
            return Result.fail("\u4fee\u6539\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u89d2\u8272\u6743\u9650\u5df2\u5b58\u5728");
        }
        role.setUpdateBy(this.jwtService.getUserName());
        role.setUpdateTime(LocalDateTime.now());
        if (this.sysRoleService.updateRole(role) > 0) {
            AccountUser loginUser = this.jwtService.getLoginUser();
            if (StringUtils.isNotNull(loginUser) && !loginUser.getUser().isAdmin()) {
                loginUser.setPermissions(this.sysPermissionService.getMenuPermission(loginUser.getUser()));
                loginUser.setUser(this.sysUserService.getByUsername(loginUser.getUsername()));
                this.jwtService.setLoginUser(loginUser);
            }
            return Result.success();
        }
        return Result.fail("\u4fee\u6539\u89d2\u8272'" + role.getRoleName() + "'\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @OperateLog(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.LIST)
    @PreAuthorize(value="@auth.hasAuthority('system:role:list')")
    @GetMapping(value={"/authUser/allocatedList"})
    public Result allocatedList(SysUser user, @RequestParam(name="pageNum", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = PageDTO.of((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<SysUser> list = this.sysUserService.selectAllocatedList((Page<SysUser>)page, user);
        return Result.succ(list);
    }

    @OperateLog(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.LIST)
    @PreAuthorize(value="@auth.hasAuthority('system:role:list')")
    @GetMapping(value={"/authUser/unallocatedList"})
    public Result unallocatedList(SysUser user, @RequestParam(name="pageNum", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        Page page = PageDTO.of((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<SysUser> list = this.sysUserService.selectUnallocatedList((Page<SysUser>)page, user);
        return Result.succ(list);
    }

    @OperateLog(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.GRANT)
    @PreAuthorize(value="@auth.hasAuthority('system:role:edit')")
    @PutMapping(value={"/authUser/selectAll"})
    public Result selectAuthUserAll(Long roleId, Long[] userIds) {
        return Result.succ(this.sysRoleService.insertAuthUsers(roleId, userIds));
    }

    @OperateLog(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.GRANT)
    @PreAuthorize(value="@auth.hasAuthority('system:role:edit')")
    @PutMapping(value={"/authUser/cancel"})
    public Result cancelAuthUser(@RequestBody SysUserRole userRole) {
        return Result.succ(this.sysRoleService.deleteAuthUser(userRole));
    }

    @OperateLog(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @PreAuthorize(value="@auth.hasAuthority('system:role:export')")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysRole role) throws Exception {
        List<SysRole> list = this.sysRoleService.selectRoleList(role);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u89d2\u8272", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), SysRole.class).sheet("\u89d2\u8272").doWrite(list);
    }

    @PreAuthorize(value="@auth.hasAuthority('system:role:query')")
    @GetMapping(value={"/deptTree/{roleId}"})
    public Result deptTree(@PathVariable(value="roleId") Long roleId) {
        HashMap<String, List<Serializable>> result = new HashMap<String, List<Serializable>>();
        result.put("checkedKeys", this.sysDeptService.selectDeptListByRoleId(roleId));
        result.put("depts", this.sysDeptService.selectDeptTreeList(new SysDept()));
        return Result.succ(result);
    }

    @PreAuthorize(value="@auth.hasAuthority('system:role:edit')")
    @OperateLog(title="\u89d2\u8272\u7ba1\u7406", businessType=BusinessType.GRANT)
    @PutMapping(value={"/authUser/cancelAll"})
    public Result cancelAuthUserAll(Long roleId, Long[] userIds) {
        return Result.succ(this.sysRoleService.deleteAuthUsers(roleId, userIds));
    }

    private LambdaQueryWrapper<SysRole> getQueryWrapper(SysRole sysRole) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)sysRole.getRoleName())) {
            query.like(SysRole::getRoleName, (Object)sysRole.getRoleName());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysRole.getRoleKey())) {
            query.like(SysRole::getRoleKey, (Object)sysRole.getRoleKey());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysRole.getStatus())) {
            query.eq(SysRole::getStatus, (Object)sysRole.getStatus());
        }
        QueryWrapperUtil.createTimeCondition(query, sysRole.getParams());
        query.orderByAsc(SysRole::getRoleSort);
        return query;
    }

    public SysRoleController(SysUserService sysUserService, SysRoleService sysRoleService, SysDeptService sysDeptService, SysPermissionService sysPermissionService, JwtService jwtService) {
        this.sysUserService = sysUserService;
        this.sysRoleService = sysRoleService;
        this.sysDeptService = sysDeptService;
        this.sysPermissionService = sysPermissionService;
        this.jwtService = jwtService;
    }
}

