/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.controller;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.annotation.OperateLog;
import cn.morethank.open.admin.common.domain.BusinessType;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.common.util.DictUtils;
import cn.morethank.open.admin.system.domain.SysPost;
import cn.morethank.open.admin.system.service.SysPostService;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/post"})
public class SysPostController {
    private static final Logger log = LoggerFactory.getLogger(SysPostController.class);
    private final SysPostService sysPostService;
    private final JwtService jwtService;
    private final DictUtils dictUtils;

    @OperateLog(title="\u5c97\u4f4d\u7ba1\u7406", businessType=BusinessType.DETAIL)
    @RequestMapping(value={"{id}"})
    @PreAuthorize(value="@auth.hasAuthority('system:post:query')")
    public Result detail(@PathVariable Long id) {
        SysPost sysPost = (SysPost)this.sysPostService.getById(id);
        return Result.succ(sysPost);
    }

    @OperateLog(title="\u5c97\u4f4d\u7ba1\u7406", businessType=BusinessType.LIST)
    @PreAuthorize(value="@auth.hasAuthority('system:post:query')")
    @GetMapping(value={"/list"})
    public Result list(SysPost sysPost, @RequestParam(name="pageNum", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        log.info("\u5206\u9875\u67e5\u8be2sysPost,\u68c0\u7d22\u53c2\u6570sysRole={},\u5206\u9875\u53c2\u6570pageNo={},pageSize={}", new Object[]{sysPost, pageNo, pageSize});
        try {
            LambdaQueryWrapper<SysPost> query = this.getQueryWrapper(sysPost);
            IPage<SysPost> pageList = this.sysPostService.selectListPage((Page<SysPost>)new Page((long)pageNo.intValue(), (long)pageSize.intValue()), query);
            log.info("\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c:{}", pageList);
            return Result.succ(pageList);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @PreAuthorize(value="@auth.hasAuthority('system:post:remove')")
    @DeleteMapping(value={"/{postIds}"})
    public Result remove(@PathVariable Long[] postIds) {
        return Result.succ(this.sysPostService.deletePostByIds(postIds));
    }

    @PreAuthorize(value="@auth.hasAuthority('system:post:add')")
    @PostMapping
    public Result add(@Validated @RequestBody SysPost post) {
        if (this.sysPostService.checkPostNameUnique(post)) {
            return Result.fail("\u65b0\u589e\u5c97\u4f4d'" + post.getPostName() + "'\u5931\u8d25\uff0c\u5c97\u4f4d\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (this.sysPostService.checkPostCodeUnique(post)) {
            return Result.fail("\u65b0\u589e\u5c97\u4f4d'" + post.getPostName() + "'\u5931\u8d25\uff0c\u5c97\u4f4d\u7f16\u7801\u5df2\u5b58\u5728");
        }
        post.setCreateBy(this.jwtService.getUserName());
        post.setCreateTime(LocalDateTime.now());
        return Result.succ(this.sysPostService.save(post));
    }

    @PreAuthorize(value="@auth.hasAuthority('system:post:edit')")
    @PutMapping
    public Result edit(@Validated @RequestBody SysPost post) {
        if (this.sysPostService.checkPostNameUnique(post)) {
            return Result.fail("\u4fee\u6539\u5c97\u4f4d'" + post.getPostName() + "'\u5931\u8d25\uff0c\u5c97\u4f4d\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (this.sysPostService.checkPostCodeUnique(post)) {
            return Result.fail("\u4fee\u6539\u5c97\u4f4d'" + post.getPostName() + "'\u5931\u8d25\uff0c\u5c97\u4f4d\u7f16\u7801\u5df2\u5b58\u5728");
        }
        post.setUpdateBy(this.jwtService.getUserName());
        post.setUpdateTime(LocalDateTime.now());
        return Result.succ(this.sysPostService.updateById(post));
    }

    @OperateLog(title="\u5c97\u4f4d\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @PreAuthorize(value="@auth.hasAuthority('system:post:export')")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysPost sysPost) throws Exception {
        LambdaQueryWrapper<SysPost> query = this.getQueryWrapper(sysPost);
        List list = this.sysPostService.list((Wrapper)query);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u5c97\u4f4d", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), SysPost.class).sheet("\u5c97\u4f4d").doWrite((Collection)list);
    }

    private LambdaQueryWrapper<SysPost> getQueryWrapper(SysPost sysPost) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)sysPost.getPostName())) {
            query.like(SysPost::getPostName, (Object)sysPost.getPostName());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysPost.getPostCode())) {
            query.like(SysPost::getPostCode, (Object)sysPost.getPostCode());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysPost.getStatus())) {
            query.eq(SysPost::getStatus, (Object)sysPost.getStatus());
        }
        return query;
    }

    public SysPostController(SysPostService sysPostService, JwtService jwtService, DictUtils dictUtils) {
        this.sysPostService = sysPostService;
        this.jwtService = jwtService;
        this.dictUtils = dictUtils;
    }
}

