/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.controller;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.annotation.OperateLog;
import cn.morethank.open.admin.common.domain.BusinessType;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.util.QueryWrapperUtil;
import cn.morethank.open.admin.system.domain.SysOperLog;
import cn.morethank.open.admin.system.service.SysOperLogService;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/operlog"})
public class SysOperLogController {
    private static final Logger log = LoggerFactory.getLogger(SysOperLogController.class);
    private final SysOperLogService sysOperLogService;

    @RequestMapping(value={"{id}"})
    public SysOperLog detail(@PathVariable Integer id) {
        SysOperLog sysOperLog = (SysOperLog)this.sysOperLogService.getById(id);
        return sysOperLog;
    }

    @DeleteMapping(value={"{id}"})
    public Object delete(@PathVariable Integer id) {
        Boolean deleted = this.sysOperLogService.removeById(id);
        return deleted;
    }

    @GetMapping(value={"/list"})
    public Result list(SysOperLog sysOperLog, @RequestParam(name="pageNum", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        log.info("\u5206\u9875\u67e5\u8be2sysOperLog,\u68c0\u7d22\u53c2\u6570sysOperLog={},\u5206\u9875\u53c2\u6570pageNo={},pageSize={}", new Object[]{sysOperLog, pageNo, pageSize});
        try {
            LambdaQueryWrapper<SysOperLog> query = this.getQueryWrapper(sysOperLog);
            IPage<SysOperLog> pageList = this.sysOperLogService.selectListPage((Page<SysOperLog>)new Page((long)pageNo.intValue(), (long)pageSize.intValue()), query);
            log.info("\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c:{}", pageList);
            return Result.succ(pageList);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @OperateLog(title="\u64cd\u4f5c\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @PreAuthorize(value="@auth.hasAuthority('monitor:operlog:export')")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysOperLog operLog) throws Exception {
        LambdaQueryWrapper<SysOperLog> query = this.getQueryWrapper(operLog);
        List list = this.sysOperLogService.list((Wrapper)query);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u64cd\u4f5c\u65e5\u5fd7", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), SysOperLog.class).sheet("\u64cd\u4f5c\u65e5\u5fd7").doWrite((Collection)list);
    }

    @OperateLog(title="\u64cd\u4f5c\u65e5\u5fd7", businessType=BusinessType.CLEAN)
    @PreAuthorize(value="@auth.hasAuthority('monitor:operlog:remove')")
    @DeleteMapping(value={"/clean"})
    public Result clean() {
        this.sysOperLogService.cleanOperLog();
        return Result.success();
    }

    private LambdaQueryWrapper<SysOperLog> getQueryWrapper(SysOperLog sysOperLog) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)sysOperLog.getTitle())) {
            query.like(SysOperLog::getTitle, (Object)sysOperLog.getTitle());
        }
        if (sysOperLog.getBusinessType() != null) {
            query.eq(SysOperLog::getBusinessType, (Object)sysOperLog.getBusinessType());
        }
        if (sysOperLog.getStatus() != null) {
            query.eq(SysOperLog::getStatus, (Object)sysOperLog.getStatus());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysOperLog.getOperName())) {
            query.like(SysOperLog::getOperName, (Object)sysOperLog.getOperName());
        }
        QueryWrapperUtil.createTimeCondition(query, sysOperLog.getParams());
        query.orderByDesc(SysOperLog::getOperId);
        return query;
    }

    public SysOperLogController(SysOperLogService sysOperLogService) {
        this.sysOperLogService = sysOperLogService;
    }
}

