/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.controller;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.system.domain.SysNotice;
import cn.morethank.open.admin.system.service.SysNoticeService;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/notice"})
public class SysNoticeController {
    private static final Logger log = LoggerFactory.getLogger(SysNoticeController.class);
    private final SysNoticeService sysNoticeService;
    private final JwtService jwtService;

    @PreAuthorize(value="@auth.hasAuthority('system:notice:query')")
    @RequestMapping(value={"{id}"})
    public Result detail(@PathVariable Long id) {
        SysNotice sysNotice = (SysNotice)this.sysNoticeService.getById(id);
        return Result.succ(sysNotice);
    }

    @PreAuthorize(value="@auth.hasAuthority('system:notice:list')")
    @GetMapping(value={"/list"})
    public Result list(SysNotice sysNotice, @RequestParam(name="pageNum", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        log.info("\u5206\u9875\u67e5\u8be2sysNotice,\u68c0\u7d22\u53c2\u6570sysNotice={},\u5206\u9875\u53c2\u6570pageNo={},pageSize={}", new Object[]{sysNotice, pageNo, pageSize});
        try {
            LambdaQueryWrapper<SysNotice> query = this.getQueryWrapper(sysNotice);
            IPage<SysNotice> pageList = this.sysNoticeService.selectListPage((Page<SysNotice>)new Page((long)pageNo.intValue(), (long)pageSize.intValue()), query);
            log.info("\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c:{}", pageList);
            return Result.succ(pageList);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @PreAuthorize(value="@auth.hasAuthority('system:notice:remove')")
    @DeleteMapping(value={"/{noticeIds}"})
    public Result remove(@PathVariable Long[] noticeIds) {
        return Result.succ(this.sysNoticeService.deleteNoticeByIds(noticeIds));
    }

    @PreAuthorize(value="@auth.hasAuthority('system:notice:add')")
    @PostMapping
    public Result add(@Validated @RequestBody SysNotice notice) {
        notice.setCreateBy(this.jwtService.getUserName());
        notice.setCreateTime(LocalDateTime.now());
        return Result.succ(this.sysNoticeService.save(notice));
    }

    @PreAuthorize(value="@auth.hasAuthority('system:notice:edit')")
    @PutMapping
    public Result edit(@Validated @RequestBody SysNotice notice) {
        notice.setUpdateBy(this.jwtService.getUserName());
        notice.setUpdateTime(LocalDateTime.now());
        return Result.succ(this.sysNoticeService.updateById(notice));
    }

    private LambdaQueryWrapper<SysNotice> getQueryWrapper(SysNotice sysNotice) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)sysNotice.getNoticeTitle())) {
            query.like(SysNotice::getNoticeTitle, (Object)sysNotice.getNoticeTitle());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysNotice.getNoticeType())) {
            query.eq(SysNotice::getNoticeType, (Object)sysNotice.getNoticeType());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysNotice.getCreateBy())) {
            query.eq(SysNotice::getCreateBy, (Object)sysNotice.getCreateBy());
        }
        return query;
    }

    public SysNoticeController(SysNoticeService sysNoticeService, JwtService jwtService) {
        this.sysNoticeService = sysNoticeService;
        this.jwtService = jwtService;
    }
}

