/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.controller;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysMenu;
import cn.morethank.open.admin.system.domain.SysUser;
import cn.morethank.open.admin.system.service.SysMenuService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/menu"})
public class SysMenuController {
    private static final Logger log = LoggerFactory.getLogger(SysMenuController.class);
    private final SysMenuService sysMenuService;
    private final JwtService jwtService;

    @PreAuthorize(value="@auth.hasAuthority('system:menu:query')")
    @RequestMapping(value={"{id}"})
    public Result detail(@PathVariable Long id) {
        SysMenu sysMenu = (SysMenu)this.sysMenuService.getById(id);
        return Result.succ(sysMenu);
    }

    @PreAuthorize(value="@auth.hasAuthority('system:menu:list')")
    @GetMapping(value={"/list"})
    public Result list(SysMenu sysMenu) {
        try {
            List<SysMenu> pageList;
            SysUser sysUser = this.jwtService.getLoginUser().getUser();
            if (sysUser.isAdmin()) {
                LambdaQueryWrapper<SysMenu> query = this.getQueryWrapper(sysMenu);
                pageList = this.sysMenuService.list((Wrapper)query);
            } else {
                sysMenu.getParams().put("userId", sysUser.getUserId());
                pageList = this.sysMenuService.selectMenuListByUserId(sysMenu);
            }
            log.info("\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c:{}", pageList);
            return Result.succ(pageList);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @PreAuthorize(value="@auth.hasAuthority('system:menu:add')")
    @PostMapping
    public Result add(@Validated @RequestBody SysMenu menu) {
        if (this.sysMenuService.checkMenuNameUnique(menu)) {
            return Result.fail("\u65b0\u589e\u83dc\u5355'" + menu.getMenuName() + "'\u5931\u8d25\uff0c\u83dc\u5355\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if ("0".equals(menu.getIsFrame()) && !StringUtils.ishttp(menu.getPath())) {
            return Result.fail("\u65b0\u589e\u83dc\u5355'" + menu.getMenuName() + "'\u5931\u8d25\uff0c\u5730\u5740\u5fc5\u987b\u4ee5http(s)://\u5f00\u5934");
        }
        menu.setCreateBy(this.jwtService.getUserName());
        menu.setCreateTime(LocalDateTime.now());
        return Result.succ(this.sysMenuService.save(menu));
    }

    @PreAuthorize(value="@auth.hasAuthority('system:menu:edit')")
    @PutMapping
    public Result edit(@Validated @RequestBody SysMenu menu) {
        if (this.sysMenuService.checkMenuNameUnique(menu)) {
            return Result.fail("\u4fee\u6539\u83dc\u5355'" + menu.getMenuName() + "'\u5931\u8d25\uff0c\u83dc\u5355\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if ("0".equals(menu.getIsFrame()) && !StringUtils.ishttp(menu.getPath())) {
            return Result.fail("\u4fee\u6539\u83dc\u5355'" + menu.getMenuName() + "'\u5931\u8d25\uff0c\u5730\u5740\u5fc5\u987b\u4ee5http(s)://\u5f00\u5934");
        }
        if (menu.getMenuId().equals(menu.getParentId())) {
            return Result.fail("\u4fee\u6539\u83dc\u5355'" + menu.getMenuName() + "'\u5931\u8d25\uff0c\u4e0a\u7ea7\u83dc\u5355\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1");
        }
        menu.setUpdateBy(this.jwtService.getUserName());
        menu.setUpdateTime(LocalDateTime.now());
        return Result.succ(this.sysMenuService.updateById(menu));
    }

    @PreAuthorize(value="@auth.hasAuthority('system:menu:remove')")
    @DeleteMapping(value={"/{menuId}"})
    public Result remove(@PathVariable(value="menuId") Long menuId) {
        if (this.sysMenuService.hasChildByMenuId(menuId)) {
            return Result.fail("\u5b58\u5728\u5b50\u83dc\u5355,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        if (this.sysMenuService.checkMenuExistRole(menuId)) {
            return Result.fail("\u83dc\u5355\u5df2\u5206\u914d,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        return Result.succ(this.sysMenuService.removeById(menuId));
    }

    private LambdaQueryWrapper<SysMenu> getQueryWrapper(SysMenu sysMenu) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)sysMenu.getMenuName())) {
            query.like(SysMenu::getMenuName, (Object)sysMenu.getMenuName());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysMenu.getVisible())) {
            query.eq(SysMenu::getVisible, (Object)sysMenu.getVisible());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysMenu.getStatus())) {
            query.eq(SysMenu::getStatus, (Object)sysMenu.getStatus());
        }
        query.orderByAsc(SysMenu::getParentId, (Object[])new SFunction[]{SysMenu::getOrderNum});
        return query;
    }

    @GetMapping(value={"/treeselect"})
    public Result treeselect(SysMenu menu) {
        List<SysMenu> menus = this.sysMenuService.selectMenuList(menu, this.jwtService.getLoginUser().getUser());
        return Result.succ(this.sysMenuService.buildMenuTreeSelect(menus));
    }

    @GetMapping(value={"/roleMenuTreeselect/{roleId}"})
    public Result roleMenuTreeselect(@PathVariable(value="roleId") Long roleId) {
        List<SysMenu> menus = this.sysMenuService.selectMenuList(this.jwtService.getLoginUser().getUser());
        HashMap<String, List<Serializable>> ajax = new HashMap<String, List<Serializable>>(2);
        ajax.put("checkedKeys", this.sysMenuService.selectMenuListByRoleId(roleId));
        ajax.put("menus", this.sysMenuService.buildMenuTreeSelect(menus));
        return Result.succ(ajax);
    }

    public SysMenuController(SysMenuService sysMenuService, JwtService jwtService) {
        this.sysMenuService = sysMenuService;
        this.jwtService = jwtService;
    }
}

