/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.controller;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.annotation.OperateLog;
import cn.morethank.open.admin.common.domain.BusinessType;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.util.QueryWrapperUtil;
import cn.morethank.open.admin.system.domain.SysLogininfor;
import cn.morethank.open.admin.system.service.SysLogininforService;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/logininfor"})
public class SysLogininforController {
    private static final Logger log = LoggerFactory.getLogger(SysLogininforController.class);
    private final SysLogininforService sysLogininforService;

    @OperateLog(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @PreAuthorize(value="@auth.hasAuthority('system:logininfor:remove')")
    @DeleteMapping(value={"{ids}"})
    public Result delete(@PathVariable Long[] ids) {
        ArrayList arrayList = new ArrayList(ids.length);
        Collections.addAll(arrayList, ids);
        this.sysLogininforService.removeByIds(arrayList);
        return Result.succ(ids.length);
    }

    @OperateLog(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.LIST)
    @PreAuthorize(value="@auth.hasAuthority('system:logininfor:list')")
    @GetMapping(value={"/list"})
    public Result list(SysLogininfor sysLogininfor, @RequestParam(name="pageNum", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        log.info("\u5206\u9875\u67e5\u8be2sysLogininfor,\u68c0\u7d22\u53c2\u6570sysLogininfor={},\u5206\u9875\u53c2\u6570pageNo={},pageSize={}", new Object[]{sysLogininfor, pageNo, pageSize});
        try {
            LambdaQueryWrapper<SysLogininfor> query = this.getQueryWrapper(sysLogininfor);
            IPage<SysLogininfor> pageList = this.sysLogininforService.selectListPage((Page<SysLogininfor>)new Page((long)pageNo.intValue(), (long)pageSize.intValue()), query);
            log.info("\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c:{}", pageList);
            return Result.succ(pageList);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @OperateLog(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @PreAuthorize(value="@auth.hasAuthority('monitor:logininfor:export')")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysLogininfor logininfor) throws Exception {
        LambdaQueryWrapper<SysLogininfor> query = this.getQueryWrapper(logininfor);
        List list = this.sysLogininforService.list((Wrapper)query);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u767b\u5f55\u65e5\u5fd7", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), SysLogininfor.class).sheet("\u767b\u5f55\u65e5\u5fd7").doWrite((Collection)list);
    }

    @PreAuthorize(value="@auth.hasAuthority('monitor:logininfor:remove')")
    @OperateLog(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.CLEAN)
    @DeleteMapping(value={"/clean"})
    public Result clean() {
        this.sysLogininforService.cleanLogininfor();
        return Result.success();
    }

    private LambdaQueryWrapper<SysLogininfor> getQueryWrapper(SysLogininfor sysLogininfor) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)sysLogininfor.getIpaddr())) {
            query.like(SysLogininfor::getIpaddr, (Object)sysLogininfor.getIpaddr());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysLogininfor.getStatus())) {
            query.eq(SysLogininfor::getStatus, (Object)sysLogininfor.getStatus());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysLogininfor.getUserName())) {
            query.eq(SysLogininfor::getUserName, (Object)sysLogininfor.getUserName());
        }
        QueryWrapperUtil.loginTimeCondition(query, sysLogininfor.getParams());
        query.orderByDesc(SysLogininfor::getInfoId);
        return query;
    }

    public SysLogininforController(SysLogininforService sysLogininforService) {
        this.sysLogininforService = sysLogininforService;
    }
}

