/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.controller;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.annotation.OperateLog;
import cn.morethank.open.admin.common.domain.BusinessType;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.common.util.QueryWrapperUtil;
import cn.morethank.open.admin.system.domain.SysDictType;
import cn.morethank.open.admin.system.service.SysDictTypeService;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/dict/type"})
public class SysDictTypeController {
    private static final Logger log = LoggerFactory.getLogger(SysDictTypeController.class);
    private final SysDictTypeService sysDictTypeService;
    private final JwtService jwtService;

    @PreAuthorize(value="@auth.hasAuthority('system:dict:query')")
    @RequestMapping(value={"{id}"})
    public Result detail(@PathVariable Long id) {
        SysDictType sysDictType = (SysDictType)this.sysDictTypeService.getById(id);
        return Result.succ(sysDictType);
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dict:list')")
    @GetMapping(value={"/list"})
    public Result list(SysDictType sysDictType, @RequestParam(name="pageNum", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        log.info("\u5206\u9875\u67e5\u8be2sysDictType,\u68c0\u7d22\u53c2\u6570sysDictType={},\u5206\u9875\u53c2\u6570pageNo={},pageSize={}", new Object[]{sysDictType, pageNo, pageSize});
        try {
            LambdaQueryWrapper<SysDictType> query = this.getQueryWrapper(sysDictType);
            IPage<SysDictType> pageList = this.sysDictTypeService.selectListPage((Page<SysDictType>)new Page((long)pageNo.intValue(), (long)pageSize.intValue()), query);
            log.info("\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c:{}", pageList);
            return Result.succ(pageList);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dict:remove')")
    @DeleteMapping(value={"/{dictIds}"})
    public Result remove(@PathVariable Long[] dictIds) {
        int count = this.sysDictTypeService.deleteDictTypeByIds(dictIds);
        return Result.succ(count);
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dict:add')")
    @PostMapping
    public Result add(@Validated @RequestBody SysDictType dict) {
        if (this.sysDictTypeService.checkDictTypeUnique(dict)) {
            return Result.fail("\u65b0\u589e\u5b57\u5178'" + dict.getDictName() + "'\u5931\u8d25\uff0c\u5b57\u5178\u7c7b\u578b\u5df2\u5b58\u5728");
        }
        dict.setCreateBy(this.jwtService.getUserName());
        dict.setCreateTime(LocalDateTime.now());
        return Result.succ(this.sysDictTypeService.save(dict));
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dict:edit')")
    @PutMapping
    public Result edit(@Validated @RequestBody SysDictType dict) {
        if (this.sysDictTypeService.checkDictTypeUnique(dict)) {
            return Result.fail("\u4fee\u6539\u5b57\u5178'" + dict.getDictName() + "'\u5931\u8d25\uff0c\u5b57\u5178\u7c7b\u578b\u5df2\u5b58\u5728");
        }
        dict.setUpdateBy(this.jwtService.getUserName());
        dict.setUpdateTime(LocalDateTime.now());
        return Result.succ(this.sysDictTypeService.updateById(dict));
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dict:remove')")
    @OperateLog(title="\u5b57\u5178\u7c7b\u578b", businessType=BusinessType.REFRESH)
    @DeleteMapping(value={"/refreshCache"})
    public Result refreshCache() {
        this.sysDictTypeService.resetDictCache();
        return Result.success();
    }

    @GetMapping(value={"/optionselect"})
    public Result optionselect() {
        List dictTypes = this.sysDictTypeService.list();
        return Result.succ(dictTypes);
    }

    @OperateLog(title="\u5b57\u5178\u7c7b\u578b", businessType=BusinessType.EXPORT)
    @PreAuthorize(value="@auth.hasAuthority('system:dict:export')")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysDictType sysDictType) throws Exception {
        LambdaQueryWrapper<SysDictType> query = this.getQueryWrapper(sysDictType);
        List list = this.sysDictTypeService.list((Wrapper)query);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u5c97\u4f4d", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), SysDictType.class).sheet("\u5c97\u4f4d").doWrite((Collection)list);
    }

    private LambdaQueryWrapper<SysDictType> getQueryWrapper(SysDictType sysDictType) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)sysDictType.getDictName())) {
            query.like(SysDictType::getDictName, (Object)sysDictType.getDictName());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysDictType.getStatus())) {
            query.eq(SysDictType::getStatus, (Object)sysDictType.getStatus());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysDictType.getDictType())) {
            query.like(SysDictType::getDictType, (Object)sysDictType.getDictType());
        }
        QueryWrapperUtil.createTimeCondition(query, sysDictType.getParams());
        return query;
    }

    public SysDictTypeController(SysDictTypeService sysDictTypeService, JwtService jwtService) {
        this.sysDictTypeService = sysDictTypeService;
        this.jwtService = jwtService;
    }
}

