/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.controller;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysDictData;
import cn.morethank.open.admin.system.service.SysDictDataService;
import cn.morethank.open.admin.system.service.SysDictTypeService;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/dict/data"})
public class SysDictDataController {
    private static final Logger log = LoggerFactory.getLogger(SysDictDataController.class);
    private final SysDictDataService sysDictDataService;
    private final SysDictTypeService sysDictTypeService;
    private final JwtService jwtService;

    @PreAuthorize(value="@auth.hasAuthority('system:dict:query')")
    @RequestMapping(value={"{id}"})
    public Result detail(@PathVariable Long id) {
        SysDictData sysDictData = (SysDictData)this.sysDictDataService.getById(id);
        return Result.succ(sysDictData);
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dict:list')")
    @GetMapping(value={"/list"})
    public Result list(SysDictData sysDictData, @RequestParam(name="pageNum", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        log.info("\u5206\u9875\u67e5\u8be2sysDictData,\u68c0\u7d22\u53c2\u6570sysDictData={},\u5206\u9875\u53c2\u6570pageNo={},pageSize={}", new Object[]{sysDictData, pageNo, pageSize});
        try {
            LambdaQueryWrapper<SysDictData> query = this.getQueryWrapper(sysDictData);
            IPage<SysDictData> pageList = this.sysDictDataService.selectListPage((Page<SysDictData>)new Page((long)pageNo.intValue(), (long)pageSize.intValue()), query);
            log.info("\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c:{}", pageList);
            return Result.succ(pageList);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @GetMapping(value={"/type/{dictType}"})
    public Result dictType(@PathVariable String dictType) {
        List<SysDictData> data = this.sysDictTypeService.selectDictDataByType(dictType);
        if (StringUtils.isNull(data)) {
            data = new ArrayList<SysDictData>();
        }
        return Result.succ(data);
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dict:remove')")
    @DeleteMapping(value={"/{dictCodes}"})
    public Result remove(@PathVariable Long[] dictCodes) {
        this.sysDictDataService.deleteDictDataByIds(dictCodes);
        return Result.success();
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dict:add')")
    @PostMapping
    public Result add(@Validated @RequestBody SysDictData dict) {
        dict.setCreateBy(this.jwtService.getUserName());
        dict.setCreateTime(LocalDateTime.now());
        return Result.succ(this.sysDictDataService.save(dict));
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dict:edit')")
    @PutMapping
    public Result edit(@Validated @RequestBody SysDictData dict) {
        dict.setUpdateBy(this.jwtService.getUserName());
        dict.setUpdateTime(LocalDateTime.now());
        return Result.succ(this.sysDictDataService.updateById(dict));
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dict:export')")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysDictData dictData) throws Exception {
        LambdaQueryWrapper<SysDictData> query = this.getQueryWrapper(dictData);
        List list = this.sysDictDataService.list((Wrapper)query);
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=post.xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), SysDictData.class).sheet("\u5b57\u5178\u6570\u636e").doWrite((Collection)list);
    }

    private LambdaQueryWrapper<SysDictData> getQueryWrapper(SysDictData dict) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)dict.getDictType())) {
            query.eq(SysDictData::getDictType, (Object)dict.getDictType());
        }
        if (StrUtil.isNotEmpty((CharSequence)dict.getDictLabel())) {
            query.like(SysDictData::getDictLabel, (Object)dict.getDictLabel());
        }
        if (StrUtil.isNotEmpty((CharSequence)dict.getStatus())) {
            query.eq(SysDictData::getStatus, (Object)dict.getStatus());
        }
        query.orderByAsc(SysDictData::getDictSort);
        return query;
    }

    public SysDictDataController(SysDictDataService sysDictDataService, SysDictTypeService sysDictTypeService, JwtService jwtService) {
        this.sysDictDataService = sysDictDataService;
        this.sysDictTypeService = sysDictTypeService;
        this.jwtService = jwtService;
    }
}

