/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.controller;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysDept;
import cn.morethank.open.admin.system.service.SysDeptService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/dept"})
public class SysDeptController {
    private static final Logger log = LoggerFactory.getLogger(SysDeptController.class);
    private final SysDeptService sysDeptService;
    private final JwtService jwtService;

    @PreAuthorize(value="@auth.hasAuthority('system:dept:query')")
    @RequestMapping(value={"{id}"})
    public Result detail(@PathVariable Long id) {
        SysDept sysDept = (SysDept)this.sysDeptService.getById(id);
        return Result.succ(sysDept);
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dept:list')")
    @GetMapping(value={"/list"})
    public Result list(SysDept dept) {
        LambdaQueryWrapper<SysDept> query = this.getQueryWrapper(dept);
        List depts = this.sysDeptService.list((Wrapper)query);
        return Result.succ(depts);
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dept:list')")
    @GetMapping(value={"/list/exclude/{deptId}"})
    public Result excludeChild(@PathVariable(value="deptId", required=false) Long deptId) {
        LambdaQueryWrapper<SysDept> query = this.getQueryWrapper(new SysDept());
        List depts = this.sysDeptService.list((Wrapper)query);
        depts.removeIf(d -> (long)d.getDeptId().intValue() == deptId || ArrayUtils.contains((Object[])StringUtils.split((String)d.getAncestors(), (String)","), (Object)(deptId + "")));
        return Result.succ(depts);
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dept:remove')")
    @DeleteMapping(value={"/{deptId}"})
    public Result remove(@PathVariable Long deptId) {
        if (this.sysDeptService.hasChildByDeptId(deptId)) {
            return Result.fail("\u5b58\u5728\u4e0b\u7ea7\u90e8\u95e8,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        if (this.sysDeptService.checkDeptExistUser(deptId)) {
            return Result.fail("\u90e8\u95e8\u5b58\u5728\u7528\u6237,\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        return Result.succ(this.sysDeptService.deleteDeptById(deptId));
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dept:add')")
    @PostMapping
    public Result add(@Validated @RequestBody SysDept dept) {
        if (this.sysDeptService.checkDeptNameUnique(dept)) {
            return Result.fail("\u65b0\u589e\u90e8\u95e8'" + dept.getDeptName() + "'\u5931\u8d25\uff0c\u90e8\u95e8\u540d\u79f0\u5df2\u5b58\u5728");
        }
        dept.setCreateBy(this.jwtService.getUserName());
        dept.setCreateTime(LocalDateTime.now());
        return Result.succ(this.sysDeptService.save(dept));
    }

    @PreAuthorize(value="@auth.hasAuthority('system:dept:edit')")
    @PutMapping
    public Result edit(@Validated @RequestBody SysDept dept) {
        Long deptId = dept.getDeptId();
        if (this.sysDeptService.checkDeptNameUnique(dept)) {
            return Result.fail("\u4fee\u6539\u90e8\u95e8'" + dept.getDeptName() + "'\u5931\u8d25\uff0c\u90e8\u95e8\u540d\u79f0\u5df2\u5b58\u5728");
        }
        if (dept.getParentId().equals(deptId)) {
            return Result.fail("\u4fee\u6539\u90e8\u95e8'" + dept.getDeptName() + "'\u5931\u8d25\uff0c\u4e0a\u7ea7\u90e8\u95e8\u4e0d\u80fd\u662f\u81ea\u5df1");
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)dept.getStatus()) && this.sysDeptService.selectNormalChildrenDeptById(deptId) > 0) {
            return Result.fail("\u8be5\u90e8\u95e8\u5305\u542b\u672a\u505c\u7528\u7684\u5b50\u90e8\u95e8\uff01");
        }
        dept.setUpdateBy(this.jwtService.getUserName());
        dept.setUpdateTime(LocalDateTime.now());
        return Result.succ(this.sysDeptService.updateById(dept));
    }

    private LambdaQueryWrapper<SysDept> getQueryWrapper(SysDept dept) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDept::getDelFlag, (Object)"0");
        if (dept.getDeptId() != null && dept.getDeptId() != 0L) {
            query.eq(SysDept::getDeptId, (Object)dept.getDeptId());
        }
        if (dept.getParentId() != null && dept.getParentId() != 0L) {
            query.eq(SysDept::getParentId, (Object)dept.getParentId());
        }
        if (StrUtil.isNotEmpty((CharSequence)dept.getDeptName())) {
            query.like(SysDept::getDeptName, (Object)dept.getDeptName());
        }
        if (StrUtil.isNotEmpty((CharSequence)dept.getStatus())) {
            query.eq(SysDept::getStatus, (Object)dept.getStatus());
        }
        query.orderByAsc(SysDept::getParentId, (Object[])new SFunction[]{SysDept::getOrderNum});
        return query;
    }

    public SysDeptController(SysDeptService sysDeptService, JwtService jwtService) {
        this.sysDeptService = sysDeptService;
        this.jwtService = jwtService;
    }
}

