/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.system.controller;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.annotation.OperateLog;
import cn.morethank.open.admin.common.domain.BusinessType;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.common.util.DictUtils;
import cn.morethank.open.admin.common.util.QueryWrapperUtil;
import cn.morethank.open.admin.system.domain.SysConfig;
import cn.morethank.open.admin.system.service.SysConfigService;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/config"})
public class SysConfigController {
    private static final Logger log = LoggerFactory.getLogger(SysConfigController.class);
    private final SysConfigService sysConfigService;
    private final JwtService jwtService;
    private final DictUtils dictUtils;

    @PreAuthorize(value="@auth.hasAuthority('system:config:query')")
    @RequestMapping(value={"{id}"})
    public Result detail(@PathVariable Long id) {
        SysConfig sysConfig = (SysConfig)this.sysConfigService.getById(id);
        return Result.succ(sysConfig);
    }

    @PreAuthorize(value="@auth.hasAuthority('system:config:list')")
    @GetMapping(value={"/list"})
    public Result list(SysConfig sysConfig, @RequestParam(name="pageNum", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        log.info("\u5206\u9875\u67e5\u8be2sysConfig,\u68c0\u7d22\u53c2\u6570sysConfig={},\u5206\u9875\u53c2\u6570pageNo={},pageSize={}", new Object[]{sysConfig, pageNo, pageSize});
        try {
            LambdaQueryWrapper<SysConfig> query = this.getQueryWrapper(sysConfig);
            IPage<SysConfig> pageList = this.sysConfigService.selectListPage((Page<SysConfig>)new Page((long)pageNo.intValue(), (long)pageSize.intValue()), query);
            log.info("\u8fd4\u56de\u67e5\u8be2\u7ed3\u679c:{}", pageList);
            return Result.succ(pageList);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    @PreAuthorize(value="@auth.hasAuthority('system:config:remove')")
    @DeleteMapping(value={"/{configIds}"})
    public Result remove(@PathVariable Long[] configIds) {
        return Result.succ(this.sysConfigService.deleteConfigByIds(configIds));
    }

    @PreAuthorize(value="@auth.hasAuthority('system:config:remove')")
    @DeleteMapping(value={"/refreshCache"})
    public Result refreshCache() {
        this.sysConfigService.resetConfigCache();
        return Result.success();
    }

    @PreAuthorize(value="@auth.hasAuthority('system:config:add')")
    @PostMapping
    public Result add(@Validated @RequestBody SysConfig config) {
        if (this.sysConfigService.checkConfigKeyUnique(config)) {
            return Result.fail("\u65b0\u589e\u53c2\u6570'" + config.getConfigName() + "'\u5931\u8d25\uff0c\u53c2\u6570\u952e\u540d\u5df2\u5b58\u5728");
        }
        config.setCreateBy(this.jwtService.getUserName());
        config.setCreateTime(LocalDateTime.now());
        return Result.succ(this.sysConfigService.save(config));
    }

    @PreAuthorize(value="@auth.hasAuthority('system:config:edit')")
    @PutMapping
    public Result edit(@Validated @RequestBody SysConfig config) {
        if (this.sysConfigService.checkConfigKeyUnique(config)) {
            return Result.fail("\u4fee\u6539\u53c2\u6570'" + config.getConfigName() + "'\u5931\u8d25\uff0c\u53c2\u6570\u952e\u540d\u5df2\u5b58\u5728");
        }
        config.setUpdateBy(this.jwtService.getUserName());
        config.setUpdateTime(LocalDateTime.now());
        return Result.succ(this.sysConfigService.updateById(config));
    }

    @OperateLog(title="\u53c2\u6570\u914d\u7f6e", businessType=BusinessType.EXPORT)
    @PreAuthorize(value="@auth.hasAuthority('system:config:export')")
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysConfig sysConfig) throws Exception {
        LambdaQueryWrapper<SysConfig> query = this.getQueryWrapper(sysConfig);
        List list = this.sysConfigService.list((Wrapper)query);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u53c2\u6570\u914d\u7f6e", "UTF-8");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        EasyExcel.write((OutputStream)response.getOutputStream(), SysConfig.class).sheet("\u53c2\u6570\u914d\u7f6e").doWrite((Collection)list);
    }

    @GetMapping(value={"/configKey/{configKey}"})
    public Result getConfigKey(@PathVariable String configKey) {
        return Result.succ(this.sysConfigService.selectConfigByKey(configKey));
    }

    private LambdaQueryWrapper<SysConfig> getQueryWrapper(SysConfig sysConfig) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (StrUtil.isNotEmpty((CharSequence)sysConfig.getConfigName())) {
            query.like(SysConfig::getConfigName, (Object)sysConfig.getConfigName());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysConfig.getConfigType())) {
            query.eq(SysConfig::getConfigType, (Object)sysConfig.getConfigType());
        }
        if (StrUtil.isNotEmpty((CharSequence)sysConfig.getConfigKey())) {
            query.like(SysConfig::getConfigKey, (Object)sysConfig.getConfigKey());
        }
        QueryWrapperUtil.createTimeCondition(query, sysConfig.getParams());
        return query;
    }

    public SysConfigController(SysConfigService sysConfigService, JwtService jwtService, DictUtils dictUtils) {
        this.sysConfigService = sysConfigService;
        this.jwtService = jwtService;
        this.dictUtils = dictUtils;
    }
}

