/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.monitor.service.impl;

import cn.morethank.open.admin.common.security.AccountUser;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.monitor.domain.SysUserOnline;
import cn.morethank.open.admin.monitor.service.SysUserOnlineService;
import org.springframework.stereotype.Service;

@Service
public class SysUserOnlineServiceImpl
implements SysUserOnlineService {
    @Override
    public SysUserOnline selectOnlineByInfo(String ipaddr, String userName, AccountUser user) {
        if (user.getIpaddr().contains(ipaddr) && user.getUsername().contains(userName)) {
            return this.loginUserToUserOnline(user);
        }
        return null;
    }

    @Override
    public SysUserOnline loginUserToUserOnline(AccountUser user) {
        if (StringUtils.isNull(user) || StringUtils.isNull(user.getUser())) {
            return null;
        }
        SysUserOnline sysUserOnline = new SysUserOnline();
        sysUserOnline.setTokenId(user.getToken());
        sysUserOnline.setUserName(user.getUsername());
        sysUserOnline.setIpaddr(user.getIpaddr());
        sysUserOnline.setLoginLocation(user.getLoginLocation());
        sysUserOnline.setBrowser(user.getBrowser());
        sysUserOnline.setOs(user.getOs());
        sysUserOnline.setLoginTime(user.getLoginTime());
        if (StringUtils.isNotNull(user.getUser().getDept())) {
            sysUserOnline.setDeptName(user.getUser().getDept().getDeptName());
        }
        return sysUserOnline;
    }

    @Override
    public SysUserOnline selectOnlineByIpaddr(String ipaddr, AccountUser user) {
        if (user.getIpaddr().contains(ipaddr)) {
            return this.loginUserToUserOnline(user);
        }
        return null;
    }

    @Override
    public SysUserOnline selectOnlineByUserName(String userName, AccountUser user) {
        if (user.getUsername().contains(userName)) {
            return this.loginUserToUserOnline(user);
        }
        return null;
    }
}

