/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.monitor.controller;

import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.security.AccountUser;
import cn.morethank.open.admin.common.service.RedisService;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.monitor.domain.SysUserOnline;
import cn.morethank.open.admin.monitor.service.SysUserOnlineService;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor/online"})
public class SysUserOnlineController {
    private final SysUserOnlineService sysUserOnlineService;
    private final RedisService redisService;

    @PreAuthorize(value="@auth.hasAuthority('monitor:online:list')")
    @GetMapping(value={"/list"})
    public Result list(String ipaddr, String userName) {
        Collection<String> keys = this.redisService.keys("login_tokens:*");
        ArrayList<SysUserOnline> userOnlineList = new ArrayList<SysUserOnline>();
        for (String key : keys) {
            SysUserOnline userOnline;
            AccountUser user = (AccountUser)this.redisService.get(key);
            if (StringUtils.isNotEmpty(ipaddr) && StringUtils.isNotEmpty(userName)) {
                if (!user.getIpaddr().contains(ipaddr) || !user.getUsername().contains(userName) || (userOnline = this.sysUserOnlineService.selectOnlineByInfo(ipaddr, userName, user)) == null) continue;
                userOnlineList.add(userOnline);
                continue;
            }
            if (StringUtils.isNotEmpty(ipaddr)) {
                if (!user.getIpaddr().contains(ipaddr) || (userOnline = this.sysUserOnlineService.selectOnlineByIpaddr(ipaddr, user)) == null) continue;
                userOnlineList.add(userOnline);
                continue;
            }
            if (StringUtils.isNotEmpty(userName) && StringUtils.isNotNull(user.getUser())) {
                if (!user.getUsername().contains(userName) || (userOnline = this.sysUserOnlineService.selectOnlineByUserName(userName, user)) == null) continue;
                userOnlineList.add(userOnline);
                continue;
            }
            userOnline = this.sysUserOnlineService.loginUserToUserOnline(user);
            if (userOnline == null) continue;
            userOnlineList.add(userOnline);
        }
        Collections.reverse(userOnlineList);
        Page pageList = new Page(0L, 0L, (long)userOnlineList.size());
        pageList.setRecords(userOnlineList);
        return Result.succ(pageList);
    }

    @PreAuthorize(value="@auth.hasAuthority('monitor:online:forceLogout')")
    @DeleteMapping(value={"/{tokenId}"})
    public Result forceLogout(@PathVariable String tokenId) {
        this.redisService.del("login_tokens:" + tokenId);
        return Result.success();
    }

    public SysUserOnlineController(SysUserOnlineService sysUserOnlineService, RedisService redisService) {
        this.sysUserOnlineService = sysUserOnlineService;
        this.redisService = redisService;
    }
}

