/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.monitor.controller;

import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor/cache"})
public class CacheController {
    private final RedisTemplate redisTemplate;

    @PreAuthorize(value="@auth.hasAuthority('monitor:cache:list')")
    @GetMapping
    public Result getInfo() throws Exception {
        Properties info = (Properties)this.redisTemplate.execute(connection -> connection.info());
        Properties commandStats = (Properties)this.redisTemplate.execute(connection -> connection.info("commandstats"));
        Object dbSize = this.redisTemplate.execute(connection -> connection.dbSize());
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        result.put("info", info);
        result.put("dbSize", dbSize);
        ArrayList pieList = new ArrayList();
        commandStats.stringPropertyNames().forEach(key -> {
            HashMap<String, String> data = new HashMap<String, String>(2);
            String property = commandStats.getProperty((String)key);
            data.put("name", StringUtils.removeStart((String)key, (String)"cmdstat_"));
            data.put("value", StringUtils.substringBetween((String)property, (String)"calls=", (String)",usec"));
            pieList.add(data);
        });
        result.put("commandStats", pieList);
        return Result.succ(result);
    }

    public CacheController(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

