/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.util;

import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import cn.morethank.open.admin.common.util.IpUtils;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysLogininfor;
import cn.morethank.open.admin.system.domain.SysOperLog;
import cn.morethank.open.admin.system.service.SysLogininforService;
import cn.morethank.open.admin.system.service.SysOperLogService;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class LogUtil {
    private static final Logger log = LoggerFactory.getLogger(LogUtil.class);

    public static void saveLoginLog(SysLogininforService sysLogininforService, String username, String status, String message, Object ... args) {
        HttpServletRequest request = LogUtil.getRequest();
        UserAgent ua = UserAgentUtil.parse((String)request.getHeader("User-Agent"));
        String ip = IpUtils.getIpAddr(request);
        CompletableFuture.runAsync(() -> {
            String address = IpUtils.getRealAddressByIP(ip);
            StringBuilder s = new StringBuilder();
            s.append(LogUtil.getBlock(ip));
            s.append(address);
            s.append(LogUtil.getBlock(username));
            s.append(LogUtil.getBlock(status));
            s.append(LogUtil.getBlock(message));
            log.info(s.toString(), args);
            String os = ua.getOs().getName();
            String browser = ua.getBrowser().getName();
            SysLogininfor logininfor = new SysLogininfor();
            logininfor.setUserName(username);
            logininfor.setIpaddr(ip);
            logininfor.setLoginLocation(address);
            logininfor.setBrowser(browser);
            logininfor.setOs(os);
            logininfor.setMsg(message);
            logininfor.setLoginTime(LocalDateTime.now());
            if (StringUtils.equalsAny((CharSequence)status, (CharSequence[])new CharSequence[]{"Success", "Logout", "Register"})) {
                logininfor.setStatus("0");
            } else if ("Error".equals(status)) {
                logininfor.setStatus("1");
            }
            sysLogininforService.save(logininfor);
        });
    }

    public static HttpServletRequest getRequest() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        return request;
    }

    public static String getBlock(Object msg) {
        if (msg == null) {
            msg = "";
        }
        return "[" + msg + "]";
    }

    public static void saveOperLog(SysOperLogService sysOperLogService, SysOperLog operLog) {
        CompletableFuture.runAsync(() -> {
            operLog.setOperLocation(IpUtils.getRealAddressByIP(operLog.getOperIp()));
            operLog.setOperTime(LocalDateTime.now());
            sysOperLogService.save(operLog);
        });
    }
}

