/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.util;

import cn.morethank.open.admin.common.service.RedisService;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.domain.SysDictData;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class DictUtils {
    @Resource
    private RedisService redisService;

    public void clearDictCache() {
        Collection<String> keys = this.redisService.keys("sys_dict:*");
        this.redisService.deleteObjects(keys);
    }

    public void setDictCache(String key, List<SysDictData> dictDatas) {
        this.redisService.set(this.getCacheKey(key), dictDatas);
    }

    public List<SysDictData> getDictCache(String key) {
        List arrayCache = (List)this.redisService.get(this.getCacheKey(key));
        return arrayCache;
    }

    public String getCacheKey(String configKey) {
        return "sys_dict:" + configKey;
    }

    public String getDictLabel(String dictType, String dictValue) {
        return this.getDictLabel(dictType, dictValue, ",");
    }

    public String getDictLabel(String dictType, String dictValue, String separator) {
        StringBuilder propertyString;
        block5: {
            propertyString = new StringBuilder();
            List<SysDictData> datas = this.getDictCache(dictType);
            if (!StringUtils.isNotNull(datas)) break block5;
            if (StringUtils.containsAny((CharSequence)separator, (CharSequence)dictValue)) {
                block0: for (SysDictData dict : datas) {
                    for (String value : dictValue.split(separator)) {
                        if (!value.equals(dict.getDictValue())) continue;
                        propertyString.append(dict.getDictLabel()).append(separator);
                        continue block0;
                    }
                }
            } else {
                for (SysDictData dict : datas) {
                    if (!dictValue.equals(dict.getDictValue())) continue;
                    return dict.getDictLabel();
                }
            }
        }
        return StringUtils.stripEnd((String)propertyString.toString(), (String)separator);
    }

    public String getDictValue(String dictType, String dictLabel) {
        return this.getDictValue(dictType, dictLabel, ",");
    }

    public String getDictValue(String dictType, String dictLabel, String separator) {
        StringBuilder propertyString = new StringBuilder();
        List<SysDictData> datas = this.getDictCache(dictType);
        if (StringUtils.containsAny((CharSequence)separator, (CharSequence)dictLabel) && StringUtils.isNotEmpty(datas)) {
            block0: for (SysDictData dict : datas) {
                for (String label : dictLabel.split(separator)) {
                    if (!label.equals(dict.getDictLabel())) continue;
                    propertyString.append(dict.getDictValue()).append(separator);
                    continue block0;
                }
            }
        } else {
            for (SysDictData dict : datas) {
                if (!dictLabel.equals(dict.getDictLabel())) continue;
                return dict.getDictValue();
            }
        }
        return StringUtils.stripEnd((String)propertyString.toString(), (String)separator);
    }

    public void removeDictCache(String key) {
        this.redisService.del(this.getCacheKey(key));
    }
}

