/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.service;

import cn.morethank.open.admin.common.exception.ServiceException;
import cn.morethank.open.admin.common.security.AccountUser;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.common.service.RedisService;
import cn.morethank.open.admin.common.service.RsaService;
import cn.morethank.open.admin.common.util.IpUtils;
import cn.morethank.open.admin.common.util.LogUtil;
import cn.morethank.open.admin.system.domain.SysUser;
import cn.morethank.open.admin.system.service.SysLogininforService;
import cn.morethank.open.admin.system.service.SysUserService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class SysLoginService {
    private static final Logger log = LoggerFactory.getLogger(SysLoginService.class);
    @Resource
    private AuthenticationManager authenticationManager;
    @Resource
    private JwtService jwtService;
    @Resource
    private RedisService redisService;
    @Resource
    private RsaService rsaService;
    @Resource
    private SysUserService sysUserService;
    @Resource
    private SysLogininforService sysLogininforService;

    public String login(String username, String password, String code, String uuid) {
        Authentication authentication;
        String user;
        try {
            String privateKey = (String)this.redisService.hget("privateKey", uuid);
            user = this.rsaService.privateDecrypt(username, privateKey);
            String passwd = this.rsaService.privateDecrypt(password, privateKey);
            UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)user, (Object)passwd);
            authentication = this.authenticationManager.authenticate((Authentication)authToken);
        }
        catch (Exception e) {
            if (e instanceof BadCredentialsException) {
                LogUtil.saveLoginLog(this.sysLogininforService, username, "Error", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef", new Object[0]);
                throw e;
            }
            LogUtil.saveLoginLog(this.sysLogininforService, username, "Error", e.getMessage(), new Object[0]);
            throw new ServiceException(e.getMessage());
        }
        LogUtil.saveLoginLog(this.sysLogininforService, user, "Success", "\u767b\u5f55\u6210\u529f", new Object[0]);
        AccountUser loginUser = (AccountUser)authentication.getPrincipal();
        this.updateUserLogin(loginUser.getUserId());
        String token = this.jwtService.generateToken(loginUser);
        return token;
    }

    public void updateUserLogin(Long userId) {
        LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)lambdaUpdateWrapper.eq(SysUser::getUserId, (Object)userId)).set(SysUser::getLoginIp, (Object)IpUtils.getIpAddr(LogUtil.getRequest()))).set(SysUser::getLoginDate, (Object)LocalDateTime.now());
        this.sysUserService.update(null, (Wrapper)lambdaUpdateWrapper);
    }
}

