/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.service;

import cn.hutool.core.lang.UUID;
import cn.hutool.http.useragent.UserAgent;
import cn.hutool.http.useragent.UserAgentUtil;
import cn.morethank.open.admin.common.security.AccountUser;
import cn.morethank.open.admin.common.service.RedisService;
import cn.morethank.open.admin.common.util.IpUtils;
import cn.morethank.open.admin.common.util.LogUtil;
import cn.morethank.open.admin.common.util.StringUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="open.admin.jwt")
public class JwtService {
    private long expire;
    private String secret;
    private String header;
    private long multiple = 4L;
    @Resource
    private RedisService redisService;

    public String generateToken(AccountUser loginUser) {
        Date nowDate = new Date();
        Date expireDate = new Date(nowDate.getTime() + 1000L * this.expire);
        byte[] keyBytes = (byte[])Decoders.BASE64.decode((Object)this.secret);
        SecretKey key = Keys.hmacShaKeyFor((byte[])keyBytes);
        String uuid = UUID.fastUUID().toString();
        loginUser.setToken(uuid);
        this.setUserAgent(loginUser);
        this.refreshToken(loginUser);
        HashMap<String, String> claims = new HashMap<String, String>(1);
        claims.put("login_user_key", uuid);
        return Jwts.builder().setClaims(claims).setHeaderParam("typ", (Object)"JWT").setSubject(loginUser.getUsername()).setIssuedAt(nowDate).setExpiration(expireDate).signWith((Key)key).compact();
    }

    public void refreshToken(AccountUser loginUser) {
        loginUser.setLoginTime(System.currentTimeMillis());
        loginUser.setExpireTime(loginUser.getLoginTime() + this.expire);
        String userKey = this.getTokenKey(loginUser.getToken());
        this.redisService.set(userKey, loginUser, this.expire);
    }

    public void verifyToken(AccountUser loginUser) {
        long currentTime;
        long expireTime = loginUser.getExpireTime();
        if (expireTime - (currentTime = System.currentTimeMillis()) <= this.expire / this.multiple) {
            this.refreshToken(loginUser);
        }
    }

    private String getTokenKey(String uuid) {
        return "login_tokens:" + uuid;
    }

    private Claims getClaimByToken(String jwt) {
        try {
            if (jwt.startsWith("Bearer")) {
                jwt = jwt.substring("Bearer".length() + 1);
            }
            byte[] keyBytes = (byte[])Decoders.BASE64.decode((Object)this.secret);
            SecretKey key = Keys.hmacShaKeyFor((byte[])keyBytes);
            return (Claims)Jwts.parserBuilder().setSigningKey((Key)key).build().parseClaimsJws(jwt).getBody();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setUserAgent(AccountUser loginUser) {
        HttpServletRequest request = LogUtil.getRequest();
        UserAgent userAgent = UserAgentUtil.parse((String)request.getHeader("User-Agent"));
        String ip = IpUtils.getIpAddr(request);
        loginUser.setIpaddr(ip);
        loginUser.setLoginLocation(IpUtils.getRealAddressByIP(ip));
        loginUser.setBrowser(userAgent.getBrowser().getName());
        loginUser.setOs(userAgent.getOs().getName());
    }

    public AccountUser getLoginUser(HttpServletRequest request) {
        String token = request.getHeader(this.header);
        if (StringUtils.isNotEmpty(token)) {
            try {
                Claims claims = this.getClaimByToken(token);
                if (claims != null) {
                    String uuid = (String)claims.get((Object)"login_user_key");
                    String userKey = this.getTokenKey(uuid);
                    AccountUser user = (AccountUser)this.redisService.get(userKey);
                    return user;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getUserName() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        AccountUser user = (AccountUser)authentication.getPrincipal();
        return user.getUsername();
    }

    public AccountUser getLoginUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        AccountUser loginUser = (AccountUser)authentication.getPrincipal();
        return loginUser;
    }

    public void setLoginUser(AccountUser loginUser) {
        if (StringUtils.isNotNull(loginUser) && StringUtils.isNotEmpty(loginUser.getToken())) {
            this.refreshToken(loginUser);
        }
    }

    public long getExpire() {
        return this.expire;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getHeader() {
        return this.header;
    }

    public long getMultiple() {
        return this.multiple;
    }

    public RedisService getRedisService() {
        return this.redisService;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setMultiple(long multiple) {
        this.multiple = multiple;
    }

    public void setRedisService(RedisService redisService) {
        this.redisService = redisService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JwtService)) {
            return false;
        }
        JwtService other = (JwtService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getExpire() != other.getExpire()) {
            return false;
        }
        if (this.getMultiple() != other.getMultiple()) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$header = this.getHeader();
        String other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        RedisService this$redisService = this.getRedisService();
        RedisService other$redisService = other.getRedisService();
        return !(this$redisService == null ? other$redisService != null : !this$redisService.equals(other$redisService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JwtService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $expire = this.getExpire();
        result = result * 59 + (int)($expire >>> 32 ^ $expire);
        long $multiple = this.getMultiple();
        result = result * 59 + (int)($multiple >>> 32 ^ $multiple);
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        RedisService $redisService = this.getRedisService();
        result = result * 59 + ($redisService == null ? 43 : $redisService.hashCode());
        return result;
    }

    public String toString() {
        return "JwtService(expire=" + this.getExpire() + ", secret=" + this.getSecret() + ", header=" + this.getHeader() + ", multiple=" + this.getMultiple() + ", redisService=" + this.getRedisService() + ")";
    }
}

