/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.service;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.security.AccountUser;
import cn.morethank.open.admin.common.util.StringUtils;
import cn.morethank.open.admin.system.service.SysUserService;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service(value="auth")
public class AuthorityService {
    public static final String ALL_PERMISSION = "*:*:*";
    public static final String SUPER_ADMIN = "admin";
    @Resource
    SysUserService sysUserService;

    public boolean hasAuthority(String permission) {
        if (StrUtil.isBlank((CharSequence)permission)) {
            return false;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return false;
        }
        AccountUser user = (AccountUser)authentication.getPrincipal();
        if (user.getUser().isAdmin()) {
            return true;
        }
        return this.hasAuthority(user.getPermissions(), permission);
    }

    private boolean hasAuthority(Set<String> permissions, String permission) {
        return permissions.contains(ALL_PERMISSION) || permissions.contains(StringUtils.trim(permission));
    }

    private boolean hasAuthority(Collection<? extends GrantedAuthority> authorities, String permission) {
        if (authorities.contains(ALL_PERMISSION)) {
            return true;
        }
        for (GrantedAuthority grantedAuthority : authorities) {
            if (!grantedAuthority.getAuthority().equals(StringUtils.trim(permission))) continue;
            return true;
        }
        return false;
    }
}

