/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.security;

import cn.morethank.open.admin.common.security.AccountUser;
import cn.morethank.open.admin.system.domain.SysUser;
import cn.morethank.open.admin.system.service.SysPermissionService;
import cn.morethank.open.admin.system.service.SysUserService;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class UserDetailServiceImpl
implements UserDetailsService {
    @Resource
    private SysUserService sysUserService;
    @Resource
    private SysPermissionService permissionService;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        SysUser sysUser = this.sysUserService.getByUsername(username);
        if (sysUser == null) {
            throw new UsernameNotFoundException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        Set<String> permissions = this.permissionService.getMenuPermission(sysUser);
        AccountUser user = new AccountUser(sysUser.getUserId(), sysUser.getDeptId(), sysUser, permissions);
        return user;
    }

    public List<GrantedAuthority> getUserAuthority(Long userId) {
        String authority = this.sysUserService.getUserAuthorityInfo(userId);
        return AuthorityUtils.commaSeparatedStringToAuthorityList((String)authority);
    }
}

