/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.security;

import cn.hutool.json.JSONUtil;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.security.AccountUser;
import cn.morethank.open.admin.common.service.JwtService;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class LoginSuccessHandler
implements AuthenticationSuccessHandler {
    @Resource
    private JwtService jwtService;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        response.setContentType("application/json;charset=UTF-8");
        ServletOutputStream outputStream = response.getOutputStream();
        AccountUser loginUser = (AccountUser)authentication.getPrincipal();
        String jwt = this.jwtService.generateToken(loginUser);
        response.setHeader(this.jwtService.getHeader(), jwt);
        Result result = Result.success("");
        outputStream.write(JSONUtil.toJsonStr(result).getBytes("UTF-8"));
        outputStream.flush();
        outputStream.close();
    }
}

