/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.security;

import cn.morethank.open.admin.common.domain.ErrorCode;
import cn.morethank.open.admin.common.exception.ServiceException;
import cn.morethank.open.admin.common.security.UserDetailServiceImpl;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class JwtAuthenticationProvider
implements AuthenticationProvider {
    @Resource
    private UserDetailServiceImpl userDetailService;
    @Resource
    @Lazy
    private PasswordEncoder passwordEncoder;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String username = (String)authentication.getPrincipal();
        String password = (String)authentication.getCredentials();
        UserDetails userDetails = this.userDetailService.loadUserByUsername(username);
        if (ObjectUtils.isEmpty((Object)userDetails) || !this.passwordEncoder.matches((CharSequence)password, userDetails.getPassword())) {
            throw new ServiceException(ErrorCode.USER_PWD_ERROR.code(), "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        return new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)password, userDetails.getAuthorities());
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }
}

