/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.security;

import cn.hutool.core.util.StrUtil;
import cn.morethank.open.admin.common.security.AccountUser;
import cn.morethank.open.admin.common.security.UserDetailServiceImpl;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.system.service.SysUserService;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtAuthenticationFilter
extends OncePerRequestFilter {
    @Resource
    private JwtService jwtService;
    @Resource
    private UserDetailServiceImpl userDetailService;
    @Resource
    private SysUserService sysUserService;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String jwt = request.getHeader(this.jwtService.getHeader());
        if (StrUtil.isBlankOrUndefined((CharSequence)jwt)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        AccountUser loginUser = this.jwtService.getLoginUser(request);
        if (loginUser != null && SecurityContextHolder.getContext().getAuthentication() == null) {
            this.jwtService.verifyToken(loginUser);
            UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)loginUser, null, null);
            authenticationToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
            SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

