/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.security;

import cn.hutool.json.JSONUtil;
import cn.morethank.open.admin.common.domain.ErrorCode;
import cn.morethank.open.admin.common.domain.Result;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.stereotype.Component;

@Component
public class JwtAccessDeniedHandler
implements AccessDeniedHandler {
    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        response.setContentType("application/json;charset=UTF-8");
        response.setStatus(HttpStatus.FORBIDDEN.value());
        ServletOutputStream os = response.getOutputStream();
        Result result = Result.fail(ErrorCode.FORBIDDEN.code(), accessDeniedException.getMessage());
        os.write(JSONUtil.toJsonStr(result).getBytes("UTF-8"));
        os.flush();
        os.close();
    }
}

