/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.security;

import cn.morethank.open.admin.common.exception.CaptchaException;
import cn.morethank.open.admin.common.security.LoginFailureHandler;
import cn.morethank.open.admin.common.service.RedisService;
import cn.morethank.open.admin.common.util.RequestUtil;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class CaptchaFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(CaptchaFilter.class);
    private final RedisService redisService;
    private final LoginFailureHandler loginFailureHandler;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String url = request.getRequestURI();
        if ("/login".equals(url) && request.getMethod().equals("POST")) {
            try {
                this.validate(request);
            }
            catch (CaptchaException e) {
                this.loginFailureHandler.onAuthenticationFailure(request, response, e);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void validate(HttpServletRequest request) throws CaptchaException {
        try {
            String body = RequestUtil.getBody(request);
            JSONObject json = JSONObject.parseObject((String)body);
            String code = json.getString("code");
            String key = json.getString("uuid");
            if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)key)) {
                throw new CaptchaException("\u9a8c\u8bc1\u7801\u9519\u8bef");
            }
            Object keyCode = this.redisService.hget("captcha_key", key);
            if (keyCode == null || !code.equalsIgnoreCase(keyCode.toString())) {
                throw new CaptchaException("\u9a8c\u8bc1\u7801\u9519\u8bef");
            }
            this.redisService.hdel("captcha_key", key);
        }
        catch (Exception e) {
            throw new CaptchaException(e.getMessage());
        }
    }

    public CaptchaFilter(RedisService redisService, LoginFailureHandler loginFailureHandler) {
        this.redisService = redisService;
        this.loginFailureHandler = loginFailureHandler;
    }
}

