/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.inject;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntiInjectXssUtils {
    private static final Logger log = LoggerFactory.getLogger(AntiInjectXssUtils.class);
    private static final Pattern[] scriptPatterns = new Pattern[]{Pattern.compile("<script>(.*?)</script>", 2), Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42), Pattern.compile("</script>", 2), Pattern.compile("<script(.*?)>", 42), Pattern.compile("eval\\((.*?)\\)", 42), Pattern.compile("expression\\((.*?)\\)", 42), Pattern.compile("javascript:", 2), Pattern.compile("vbscript:", 2), Pattern.compile("onload(.*?)=", 42)};
    private static String badSql = "\\b(and|or)\\b.{1,6}?(=|>|<|\\bin\\b|\\blike\\b)|\\/\\*.+?\\*\\/|<\\s*script\\b|\\bEXEC\\b|UNION.+?SELECT|UPDATE.+?SET|INSERT\\s+INTO.+?VALUES|(SELECT|DELETE).+?FROM|(CREATE|ALTER|DROP|TRUNCATE)\\s+(TABLE|DATABASE)|information_schema|table_schema";
    private static Pattern sqlPattern = Pattern.compile(badSql, 2);

    public static String xssGetClean(String value) throws UnsupportedEncodingException {
        if (value != null) {
            value = value.replaceAll("\u0000|\n|\r", "");
            for (Pattern pattern : scriptPatterns) {
                value = pattern.matcher(value).replaceAll("");
            }
        }
        return AntiInjectXssUtils.cleanGetSqlKeyWords(value);
    }

    public static String xssPostClean(String value) {
        if (value != null) {
            value = value.replaceAll("\u0000|\n|\r", "");
            for (Pattern pattern : scriptPatterns) {
                value = pattern.matcher(value).replaceAll("");
            }
            value = value.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        return AntiInjectXssUtils.cleanPostSqlKeyWords(value);
    }

    private static String cleanGetSqlKeyWords(String value) throws UnsupportedEncodingException {
        if (value == null || value.trim().length() == 0) {
            return value;
        }
        String lowerValue = URLDecoder.decode(value, "UTF-8").toLowerCase();
        boolean isContains = ((Stream)Stream.of(lowerValue.split("\\&")).map(kp -> kp.substring(kp.indexOf("=") + 1)).parallel()).anyMatch(param -> {
            if (sqlPattern.matcher((CharSequence)param).find()) {
                String msg = String.format("\u53c2\u6570\u4e2d\u5305\u542b\u4e0d\u5141\u8bb8sql\u7684\u5173\u952e\u8bcd:%s", param);
                log.error(msg);
                return true;
            }
            return false;
        });
        return isContains ? "admin_forbidden" : value;
    }

    private static String cleanPostSqlKeyWords(String value) {
        JSONObject json = null;
        try {
            json = JSONObject.parseObject((String)value);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (json == null) {
            return value;
        }
        JSONObject map = json;
        HashMap mapjson = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            Object val = entry.getValue();
            if (val == null) continue;
            String value1 = val.toString();
            String lowerValue = value1.toLowerCase();
            if (sqlPattern.matcher(lowerValue).find()) {
                String msg = String.format("%s\u53c2\u6570\u4e2d\u5305\u542b\u4e0d\u5141\u8bb8sql\u7684\u5173\u952e\u8bcd:%s", ((String)entry.getKey()).toString(), value1);
                log.error(msg);
                value1 = "admin_forbidden";
                mapjson.put(entry.getKey(), value1);
                break;
            }
            mapjson.put(entry.getKey(), (String)entry.getValue());
        }
        return JSONObject.toJSONString(mapjson, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
    }
}

