/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.inject;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.StreamUtils;

public class AntiInjectRequestWrapper
extends HttpServletRequestWrapper {
    private byte[] requestBody;
    private Map<String, String[]> parameterMap;

    public AntiInjectRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.parameterMap = request.getParameterMap();
        this.requestBody = StreamUtils.copyToByteArray((InputStream)request.getInputStream());
    }

    public String[] getParameterValues(String name) {
        if (this.parameterMap != null && this.parameterMap.size() > 0) {
            return this.parameterMap.get(name);
        }
        return null;
    }

    public String getParameter(String name) {
        return super.getParameter(name);
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.requestBody);
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public Enumeration<String> getParameterNames() {
        return super.getParameterNames();
    }
}

