/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.inject;

import cn.morethank.open.admin.common.exception.FailedReqeustException;
import cn.morethank.open.admin.common.inject.AntiInjectXssUtils;
import cn.morethank.open.admin.common.util.RequestUtil;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AntiInjectInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AntiInjectInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        log.debug("------------AntiInjectInterceptor begin--------------");
        String servletPath = request.getServletPath();
        String url = request.getPathInfo() == null ? servletPath : servletPath + request.getPathInfo();
        this.checkParams(request, url, request.getParameterNames());
        this.checkParams(request, url, request.getHeaderNames());
        String method = request.getMethod().toUpperCase();
        if ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) {
            String body = RequestUtil.getBody(request);
            if (StringUtils.hasLength((String)body)) {
                log.info("{} - {} XSS\u5904\u7406\u524d\u53c2\u6570\uff1a{}", new Object[]{method, url, body});
                body = AntiInjectXssUtils.xssPostClean(body);
                log.info("{} - {} XSS\u5904\u7406\u540e\u53c2\u6570\uff1a{}", new Object[]{method, url, body});
            }
            if (body.contains("admin_forbidden")) {
                log.error("{} - [{}\uff1a{}] \u53c2\u6570\uff1a{}, \u5305\u542b\u4e0d\u5141\u8bb8sql\u7684\u5173\u952e\u8bcd\uff0c\u8bf7\u6c42\u62d2\u7edd", new Object[]{method, url, body});
                throw new FailedReqeustException("\u5305\u542b\u4e0d\u5141\u8bb8\u7684\u975e\u6cd5\u5173\u952e\u8bcd\uff0c\u8bf7\u6c42\u62d2\u7edd");
            }
        }
        return true;
    }

    private void checkParams(HttpServletRequest request, String url, Enumeration<?> params) {
        String paramName = null;
        String paramVale = null;
        while (params.hasMoreElements()) {
            paramName = (String)params.nextElement();
            String oldValue = paramVale = request.getParameter(paramName);
            log.debug("\u539f\u8bf7\u6c42\u53c2\u6570\u503c\u4e3a\uff1a{}", (Object)paramVale);
            try {
                paramVale = AntiInjectXssUtils.xssGetClean(paramVale);
            }
            catch (Exception e) {
                log.error("\u8bf7\u6c42\u6e05\u7406xss\u653b\u51fb\u5f02\u5e38", (Throwable)e);
                log.error("\u8bf7\u6c42\u3010" + url + "\u3011\u53c2\u6570\u4e2d\u6e05\u7406xss\u653b\u51fb\u5f02\u5e38, \u8bf7\u6c42\u62d2\u7edd");
                throw new FailedReqeustException("invalid xss attack");
            }
            log.debug("\u4fee\u6539\u540e\u53c2\u6570\u503c\u4e3a\uff1a{}", (Object)paramVale);
            if (paramVale == null || !paramVale.contains("admin_forbidden")) continue;
            String message = paramName + " invalid content\uff1a" + oldValue;
            log.error("\u8bf7\u6c42\u3010" + url + "\u3011\u53c2\u6570\u4e2d\u5305\u542b\u4e0d\u5141\u8bb8sql\u7684\u5173\u952e\u8bcd, \u8bf7\u6c42\u62d2\u7edd");
            throw new FailedReqeustException(message);
        }
    }
}

