/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.exception;

import cn.morethank.open.admin.common.domain.ErrorCode;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.exception.ServiceException;
import io.jsonwebtoken.JwtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={AccessDeniedException.class})
    public Result handler(AccessDeniedException e) {
        e.printStackTrace();
        log.info("security\u6743\u9650\u4e0d\u8db3\uff1a{}", (Object)e.getMessage());
        return Result.fail(ErrorCode.USER_ACCESS_ERROR.code(), e.getMessage());
    }

    @ExceptionHandler(value={JwtException.class})
    public Result handler(JwtException e) {
        e.printStackTrace();
        log.info("\u767b\u5f55\u72b6\u6001\u5df2\u8fc7\u671f\uff1a{}", (Object)e.getMessage());
        return Result.unauthorized();
    }

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={ServiceException.class})
    public Result handler(ServiceException e) {
        log.info("\u4e1a\u52a1\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        return Result.fail(ErrorCode.USER_PWD_ERROR.code(), e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result handler(MethodArgumentNotValidException e) {
        log.info("\u5b9e\u4f53\u6821\u9a8c\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        BindingResult bindingResult = e.getBindingResult();
        ObjectError objectError = (ObjectError)bindingResult.getAllErrors().stream().findFirst().get();
        return Result.fail(ErrorCode.ENTITY_VALID_ERROR.code(), objectError.getDefaultMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public Result handler(IllegalArgumentException e) {
        log.error("Assert\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        return Result.fail(ErrorCode.UNKNOWN.code(), e.getMessage());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public Result handler(RuntimeException e) {
        log.error("\u8fd0\u884c\u65f6\u5f02\u5e38\uff1a{}", (Throwable)e);
        return Result.fail(ErrorCode.UNKNOWN.code(), e.getMessage());
    }
}

