/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.domain;

import cn.morethank.open.admin.common.domain.ErrorCode;
import java.io.Serializable;
import org.springframework.http.HttpStatus;

public class Result<T>
implements Serializable {
    private int status;
    private String errorCode;
    private String message;
    private T data;

    private static <T> Result<T> result(int status, String errorCode, String message, T data) {
        Result<T> result = new Result<T>();
        result.setStatus(status);
        result.setErrorCode(errorCode);
        result.setMessage(message);
        result.setData(data);
        return result;
    }

    public static <T> Result<T> success(String message, T data) {
        return Result.result(HttpStatus.OK.value(), null, message, data);
    }

    public static <T> Result<T> success() {
        return Result.success("\u64cd\u4f5c\u6210\u529f", null);
    }

    public static <T> Result<T> success(String message) {
        return Result.success(message, null);
    }

    public static <T> Result<T> succ(T data) {
        return Result.success("\u64cd\u4f5c\u6210\u529f", data);
    }

    public static <T> Result<T> fail(String errorCode, String message, T data) {
        return Result.result(HttpStatus.BAD_REQUEST.value(), errorCode, message, data);
    }

    public static <T> Result<T> fail() {
        return Result.fail(null, "\u64cd\u4f5c\u5931\u8d25", null);
    }

    public static <T> Result<T> error(String errorCode) {
        return Result.fail(errorCode, "\u64cd\u4f5c\u5931\u8d25", null);
    }

    public static <T> Result<T> fail(String message) {
        return Result.fail(null, message, null);
    }

    public static <T> Result<T> fail(String errorCode, String message) {
        return Result.fail(errorCode, message, null);
    }

    public static <T> Result<T> unauthorized() {
        return Result.result(HttpStatus.UNAUTHORIZED.value(), ErrorCode.UNAUTHORIZED.code(), "\u672a\u6388\u6743\u8bbf\u95ee", null);
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(status=" + this.getStatus() + ", errorCode=" + this.getErrorCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }
}

