/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.controller;

import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.service.JwtService;
import cn.morethank.open.admin.common.service.SysLoginService;
import cn.morethank.open.admin.system.domain.SysMenu;
import cn.morethank.open.admin.system.domain.SysUser;
import cn.morethank.open.admin.system.service.SysMenuService;
import cn.morethank.open.admin.system.service.SysPermissionService;
import com.alibaba.fastjson2.JSONObject;
import java.util.List;
import java.util.Set;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SysLoginController {
    private final SysLoginService sysLoginService;
    private final SysPermissionService sysPermissionService;
    private final JwtService jwtService;
    private final SysMenuService sysMenuService;

    @PostMapping(value={"/login"})
    public Result login(@RequestBody JSONObject loginBody) {
        String username = loginBody.getString("username");
        String password = loginBody.getString("password");
        String code = loginBody.getString("code");
        String uuid = loginBody.getString("uuid");
        String token = this.sysLoginService.login(username, password, code, uuid);
        return Result.success("\u64cd\u4f5c\u6210\u529f", token);
    }

    @GetMapping(value={"getInfo"})
    public Result getInfo() {
        SysUser user = this.jwtService.getLoginUser().getUser();
        Set<String> roles = this.sysPermissionService.getRolePermission(user);
        Set<String> permissions = this.sysPermissionService.getMenuPermission(user);
        JSONObject data = new JSONObject();
        data.put((Object)"user", (Object)user);
        data.put((Object)"roles", roles);
        data.put((Object)"permissions", permissions);
        return Result.succ(data);
    }

    @GetMapping(value={"getRouters"})
    public Result getRouters() {
        SysUser user = this.jwtService.getLoginUser().getUser();
        List<SysMenu> menus = this.sysMenuService.selectMenuTreeByUserId(user.getUserId());
        return Result.succ(this.sysMenuService.buildMenus(menus));
    }

    public SysLoginController(SysLoginService sysLoginService, SysPermissionService sysPermissionService, JwtService jwtService, SysMenuService sysMenuService) {
        this.sysLoginService = sysLoginService;
        this.sysPermissionService = sysPermissionService;
        this.jwtService = jwtService;
        this.sysMenuService = sysMenuService;
    }
}

