/*
 * Decompiled with CFR 0.152.
 */
package cn.morethank.open.admin.common.controller;

import cn.hutool.core.io.IoUtil;
import cn.morethank.open.admin.common.captcha.CaptchaRandom;
import cn.morethank.open.admin.common.captcha.PngCaptcha;
import cn.morethank.open.admin.common.config.CaptchaConfig;
import cn.morethank.open.admin.common.domain.Result;
import cn.morethank.open.admin.common.service.RedisService;
import cn.morethank.open.admin.common.service.RsaService;
import com.alibaba.fastjson2.JSONObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import sun.misc.BASE64Encoder;

@RestController
public class CaptchaController {
    private static final Logger log = LoggerFactory.getLogger(CaptchaController.class);
    private final CaptchaConfig captchaConfig;
    private final RedisService redisService;
    private final RsaService rsaService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/captchaImage"})
    public Result captcha() {
        ByteArrayOutputStream os = null;
        try {
            int len = this.captchaConfig.getLen();
            PngCaptcha captcha = new PngCaptcha(this.captchaConfig.getWidth(), this.captchaConfig.getHeight(), len);
            String code = CaptchaRandom.alphas(len);
            String uuid = UUID.randomUUID().toString();
            BufferedImage image = captcha.graphicsImage(code);
            os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "jpg", os);
            BASE64Encoder encoder = new BASE64Encoder();
            StringBuilder sb = new StringBuilder();
            sb.append(encoder.encode(os.toByteArray()));
            long timeout = 300L;
            this.redisService.hset("captcha_key", uuid, code, timeout);
            log.info("\u9a8c\u8bc1\u7801 -- {} - {}", (Object)uuid, (Object)code);
            Map<String, String> rsaKeys = this.rsaService.getKeys();
            this.redisService.hset("privateKey", uuid, rsaKeys.get("privateKey"), timeout);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"publicKey", (Object)rsaKeys.get("publicKey"));
            jsonObject.put((Object)"token", (Object)uuid);
            jsonObject.put((Object)"base64Img", (Object)sb);
            Result<JSONObject> result = Result.succ(jsonObject);
            IoUtil.close((Closeable)os);
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IoUtil.close(os);
        }
        return Result.fail();
    }

    @GetMapping(value={"/getEncryptKey"})
    public Result getEncryptKey() {
        String uuid = UUID.randomUUID().toString();
        Map<String, String> rsaKeys = this.rsaService.getKeys();
        long timeout = 300L;
        this.redisService.hset("privateKey", uuid, rsaKeys.get("privateKey"), timeout);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"publicKey", (Object)rsaKeys.get("publicKey"));
        jsonObject.put((Object)"token", (Object)uuid);
        return Result.succ(jsonObject);
    }

    public CaptchaController(CaptchaConfig captchaConfig, RedisService redisService, RsaService rsaService) {
        this.captchaConfig = captchaConfig;
        this.redisService = redisService;
        this.rsaService = rsaService;
    }
}

